/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.Properties;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.yaml.SpringProfileDocumentMatcher;
import org.springframework.boot.yaml.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

public class YamlPropertySourceLoader
implements PropertySourceLoader {
    @Override
    public String[] getFileExtensions() {
        return new String[]{"yml", "yaml"};
    }

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile) throws IOException {
        if (ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null)) {
            YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
            if (profile == null) {
                factory.setMatchDefault(true);
                factory.setDocumentMatchers(new SpringProfileDocumentMatcher());
            } else {
                factory.setMatchDefault(false);
                factory.setDocumentMatchers(new SpringProfileDocumentMatcher(profile));
            }
            factory.setResources(new Resource[]{resource});
            Properties properties = factory.getObject();
            if (!properties.isEmpty()) {
                return new PropertiesPropertySource(name, properties);
            }
        }
        return null;
    }
}

