/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.prometheus;

import io.prometheus.metrics.config.ExporterProperties;
import io.prometheus.metrics.config.PrometheusProperties;
import io.prometheus.metrics.config.PrometheusPropertiesLoader;
import io.prometheus.metrics.expositionformats.ExpositionFormats;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.Producible;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.prometheus.PrometheusOutputFormat;

@WebEndpoint(id="prometheus")
public class PrometheusScrapeEndpoint {
    private static final int METRICS_SCRAPE_CHARS_EXTRA = 1024;
    private final PrometheusRegistry prometheusRegistry;
    private final ExpositionFormats expositionFormats;
    private volatile int nextMetricsScrapeSize = 16;

    public PrometheusScrapeEndpoint(PrometheusRegistry prometheusRegistry, @Nullable Properties exporterProperties) {
        this.prometheusRegistry = prometheusRegistry;
        PrometheusProperties prometheusProperties = exporterProperties != null ? PrometheusPropertiesLoader.load((Map)exporterProperties) : PrometheusPropertiesLoader.load();
        this.expositionFormats = ExpositionFormats.init((ExporterProperties)prometheusProperties.getExporterProperties());
    }

    @ReadOperation(producesFrom=PrometheusOutputFormat.class)
    public WebEndpointResponse<byte[]> scrape(PrometheusOutputFormat format, @Nullable Set<String> includedNames) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.nextMetricsScrapeSize);
            MetricSnapshots metricSnapshots = includedNames != null ? this.prometheusRegistry.scrape(includedNames::contains) : this.prometheusRegistry.scrape();
            format.write(this.expositionFormats, outputStream, metricSnapshots);
            byte[] content = outputStream.toByteArray();
            this.nextMetricsScrapeSize = content.length + 1024;
            return new WebEndpointResponse((Object)content, (Producible)format);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Writing metrics failed", ex);
        }
    }
}

