/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mail.health;

import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.util.StringUtils;

public class MailHealthIndicator
extends AbstractHealthIndicator {
    private final JavaMailSenderImpl mailSender;

    public MailHealthIndicator(JavaMailSenderImpl mailSender) {
        super("Mail health check failed");
        this.mailSender = mailSender;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        String host = this.mailSender.getHost();
        int port = this.mailSender.getPort();
        StringBuilder location = new StringBuilder(host != null ? host : "");
        if (port != -1) {
            location.append(":").append(port);
        }
        if (StringUtils.hasLength((CharSequence)location)) {
            builder.withDetail("location", (Object)location.toString());
        }
        this.mailSender.testConnection();
        builder.up();
    }
}

