/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.ImmediateRequeueAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;

public class ImmediateRequeueMessageRecoverer
implements MessageRecoverer {
    protected Log logger = LogFactory.getLog(ImmediateRequeueMessageRecoverer.class);

    @Override
    public void recover(Message message, @Nullable Throwable cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Retries exhausted for message " + String.valueOf(message) + "; requeuing..."), cause);
        }
        if (cause != null) {
            throw new ImmediateRequeueAmqpException(cause);
        }
        throw new ImmediateRequeueAmqpException("Re-queueing for message: " + String.valueOf(message));
    }
}

