/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParameterList;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.NamedDataSource;
import org.simplejavamail.internal.util.Preconditions;

public class MimeMessageHelper {
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();
    private static final String HEADER_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";

    private MimeMessageHelper() {
    }

    static void setSubject(@NotNull Email email, EmailGovernance governance, MimeMessage message) throws MessagingException {
        String subject = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getSubject);
        message.setSubject(subject, CHARACTER_ENCODING);
    }

    static void setFrom(@NotNull Email email, EmailGovernance governance, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        Recipient fromRecipient = (Recipient)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getFromRecipient);
        if (fromRecipient != null) {
            message.setFrom((Address)new InternetAddress(fromRecipient.getAddress(), fromRecipient.getName(), CHARACTER_ENCODING));
        }
    }

    static void setRecipients(Email email, EmailGovernance governance, Message message) throws UnsupportedEncodingException, MessagingException {
        ArrayList recipients = MiscUtil.orOtherList((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getRecipients);
        for (Recipient recipient : recipients) {
            message.addRecipient(recipient.getType(), (Address)new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING));
        }
    }

    static void setReplyTo(@NotNull Email email, EmailGovernance governance, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = (Recipient)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getReplyToRecipient);
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    static void setTexts(@NotNull Email email, EmailGovernance governance, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        String htmlText;
        String plainText = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getPlainText);
        if (plainText != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(plainText, CHARACTER_ENCODING);
            messagePart.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, email.getContentTransferEncoding().getEncoder());
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if ((htmlText = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getHTMLText)) != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)htmlText, "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
            messagePartHTML.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, email.getContentTransferEncoding().getEncoder());
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
        String calendarText = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getCalendarText);
        CalendarMethod calendarMethod = (CalendarMethod)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getCalendarMethod);
        if (calendarText != null && calendarMethod != null) {
            MimeBodyPart messagePartCalendar = new MimeBodyPart();
            messagePartCalendar.setContent((Object)calendarText, "text/calendar; charset=\"" + CHARACTER_ENCODING + "\"; method=\"" + calendarMethod + "\"");
            messagePartCalendar.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, email.getContentTransferEncoding().getEncoder());
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartCalendar);
        }
    }

    static void setTexts(@NotNull Email email, EmailGovernance governance, MimePart messagePart) throws MessagingException {
        String htmlText;
        String plainText = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getPlainText);
        if (plainText != null) {
            messagePart.setText(plainText, CHARACTER_ENCODING);
        }
        if ((htmlText = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getHTMLText)) != null) {
            messagePart.setContent((Object)htmlText, "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
        }
        String calendarText = (String)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getCalendarText);
        CalendarMethod calendarMethod = (CalendarMethod)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getCalendarMethod);
        if (calendarText != null && calendarMethod != null) {
            messagePart.setContent((Object)calendarText, "text/calendar; charset=\"" + CHARACTER_ENCODING + "\"; method=\"" + calendarMethod + "\"");
        }
        messagePart.addHeader(HEADER_CONTENT_TRANSFER_ENCODING, email.getContentTransferEncoding().getEncoder());
    }

    static void configureForwarding(@NotNull Email email, EmailGovernance governance, @NotNull MimeMultipart multipartRootMixed) throws MessagingException {
        MimeMessage emailToForward = (MimeMessage)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getEmailToForward);
        if (emailToForward != null) {
            MimeBodyPart fordwardedMessage = new MimeBodyPart();
            fordwardedMessage.setContent((Object)emailToForward, "message/rfc822");
            multipartRootMixed.addBodyPart((BodyPart)fordwardedMessage);
        }
    }

    static void setEmbeddedImages(@NotNull Email email, EmailGovernance governance, MimeMultipart multipartRelated) throws MessagingException {
        ArrayList attachmentResources = MiscUtil.orOtherList((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getEmbeddedImages);
        for (AttachmentResource embeddedImage : attachmentResources) {
            multipartRelated.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    static void setAttachments(@NotNull Email email, EmailGovernance governance, MimeMultipart multipartRoot) throws MessagingException {
        ArrayList attachmentResources = MiscUtil.orOtherList((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getAttachments);
        for (AttachmentResource attachment : attachmentResources) {
            multipartRoot.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(attachment, "attachment"));
        }
    }

    static void setHeaders(@NotNull Email email, EmailGovernance governance, Message message) throws UnsupportedEncodingException, MessagingException {
        Boolean useReturnReceiptTo;
        HashMap<String, Collection<String>> collectedHeaders = new HashMap<String, Collection<String>>();
        if (governance.getEmailDefaults() != null) {
            MimeMessageHelper.addOrOverrideHeaders(collectedHeaders, governance.getEmailDefaults().getHeaders());
        }
        MimeMessageHelper.addOrOverrideHeaders(collectedHeaders, email.getHeaders());
        if (governance.getEmailOverrides() != null) {
            MimeMessageHelper.addOrOverrideHeaders(collectedHeaders, governance.getEmailOverrides().getHeaders());
        }
        for (Map.Entry<String, Collection<String>> header : collectedHeaders.entrySet()) {
            MimeMessageHelper.setHeader(message, header);
        }
        Boolean useDispositionNotificationTo = (Boolean)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getUseDispositionNotificationTo);
        if (Boolean.TRUE.equals(useDispositionNotificationTo)) {
            Recipient dispositionTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getDispositionNotificationTo), (String)"dispositionNotificationTo");
            InternetAddress address = new InternetAddress(dispositionTo.getAddress(), dispositionTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Disposition-Notification-To", address.toString());
        }
        if (Boolean.TRUE.equals(useReturnReceiptTo = (Boolean)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getUseReturnReceiptTo))) {
            Recipient returnReceiptTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)MiscUtil.orOther((Object)email, (Object)governance.getEmailDefaults(), (Object)governance.getEmailOverrides(), Email::getReturnReceiptTo), (String)"returnReceiptTo");
            InternetAddress address = new InternetAddress(returnReceiptTo.getAddress(), returnReceiptTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Return-Receipt-To", address.toString());
        }
    }

    private static void addOrOverrideHeaders(HashMap<String, Collection<String>> collectedHeaders, @NotNull Map<String, Collection<String>> headers) {
        headers.forEach((headerKey, headerValues) -> {
            collectedHeaders.putIfAbsent((String)headerKey, new ArrayList());
            ((Collection)collectedHeaders.get(headerKey)).clear();
            ((Collection)collectedHeaders.get(headerKey)).addAll(headerValues);
        });
    }

    private static void setHeader(Message message, Map.Entry<String, Collection<String>> header) throws UnsupportedEncodingException, MessagingException {
        for (String headerValue : header.getValue()) {
            String headerName = header.getKey();
            String headerValueEncoded = MimeUtility.encodeText((String)headerValue, (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValueEncoded);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        String resourceName = MimeMessageHelper.determineResourceName(attachmentResource, true);
        String fileName = MimeMessageHelper.determineResourceName(attachmentResource, false);
        attachmentPart.setDataHandler(new DataHandler((DataSource)new NamedDataSource(fileName, attachmentResource.getDataSource())));
        attachmentPart.setFileName(fileName);
        String contentType = attachmentResource.getDataSource().getContentType();
        ParameterList pl = new ParameterList();
        pl.set("filename", fileName);
        pl.set("name", fileName);
        attachmentPart.setHeader("Content-Type", contentType + pl);
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setHeader("Content-Description", MimeMessageHelper.determineAttachmentDescription(attachmentResource));
        if (!MiscUtil.valueNullOrEmpty((Object)attachmentResource.getContentTransferEncoding())) {
            attachmentPart.setHeader(HEADER_CONTENT_TRANSFER_ENCODING, attachmentResource.getContentTransferEncoding().getEncoder());
        }
        attachmentPart.setDisposition(dispositionType);
        return attachmentPart;
    }

    static String determineResourceName(AttachmentResource attachmentResource, boolean encodeResourceName) {
        String datasourceName = attachmentResource.getDataSource().getName();
        String resourceName = !MiscUtil.valueNullOrEmpty((Object)attachmentResource.getName()) ? attachmentResource.getName() : (!MiscUtil.valueNullOrEmpty((Object)datasourceName) ? datasourceName : "resource" + UUID.randomUUID());
        if (!MiscUtil.valueNullOrEmpty((Object)datasourceName)) {
            resourceName = MimeMessageHelper.possiblyAddExtension(datasourceName, resourceName);
        }
        return encodeResourceName ? MiscUtil.encodeText((String)resourceName) : resourceName;
    }

    @NotNull
    private static String possiblyAddExtension(String datasourceName, String resourceName) {
        String extension;
        String possibleFilename = datasourceName;
        if (!resourceName.contains(".") && possibleFilename.contains(".") && !resourceName.endsWith(extension = possibleFilename.substring(possibleFilename.lastIndexOf(".")))) {
            resourceName = resourceName + extension;
        }
        return resourceName;
    }

    @Nullable
    private static String determineAttachmentDescription(AttachmentResource attachmentResource) {
        return Optional.ofNullable(attachmentResource.getDescription()).map(MiscUtil::encodeText).orElse(null);
    }
}

