/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;

public class ConstructorPropertyMeta<T, P>
extends PropertyMeta<T, P> {
    private final ScoredSetter<T, P> scoredSetter;
    private final ScoredGetter<T, P> scoredGetter;
    private final Parameter parameter;
    private final InstantiatorDefinition instantiatorDefinition;
    private final Object[] defineProperties;

    public ConstructorPropertyMeta(String name, Type ownerType, ReflectionService reflectService, Parameter parameter, InstantiatorDefinition instantiatorDefinition, Object[] defineProperties) {
        this(name, ownerType, reflectService, parameter, ScoredGetter.nullGetter(), ScoredSetter.nullSetter(), instantiatorDefinition, defineProperties);
    }

    public ConstructorPropertyMeta(String name, Type ownerType, ReflectionService reflectService, Parameter parameter, ScoredGetter<T, P> scoredGetter, ScoredSetter<T, P> scoredSetter, InstantiatorDefinition instantiatorDefinition, Object[] defineProperties) {
        super(name, ownerType, reflectService);
        this.parameter = parameter;
        this.scoredGetter = scoredGetter;
        this.scoredSetter = scoredSetter;
        this.instantiatorDefinition = instantiatorDefinition;
        this.defineProperties = defineProperties;
    }

    @Override
    public Setter<? super T, ? super P> getSetter() {
        return this.scoredSetter.getSetter();
    }

    @Override
    public Getter<? super T, ? extends P> getGetter() {
        return this.scoredGetter.getGetter();
    }

    public ConstructorPropertyMeta<T, P> defineProperties(Object[] defineProperties) {
        if (defineProperties != null) {
            return new ConstructorPropertyMeta<T, P>(this.getName(), this.getOwnerType(), this.reflectService, this.parameter, this.scoredGetter, this.scoredSetter, this.instantiatorDefinition, ObjectPropertyMeta.concatenate(this.defineProperties, defineProperties));
        }
        return this;
    }

    public ConstructorPropertyMeta<T, P> getter(ScoredGetter<T, P> getter) {
        if (getter.isBetterThan(this.scoredGetter)) {
            return new ConstructorPropertyMeta<T, P>(this.getName(), this.getOwnerType(), this.reflectService, this.parameter, getter, this.scoredSetter, this.instantiatorDefinition, this.defineProperties);
        }
        return this;
    }

    public ConstructorPropertyMeta<T, P> setter(ScoredSetter<T, P> setter) {
        if (setter.isBetterThan(this.scoredSetter)) {
            return new ConstructorPropertyMeta<T, P>(this.getName(), this.getOwnerType(), this.reflectService, this.parameter, this.scoredGetter, setter, this.instantiatorDefinition, this.defineProperties);
        }
        return this;
    }

    @Override
    public Type getPropertyType() {
        return this.parameter.getGenericType();
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public boolean isConstructorProperty() {
        return true;
    }

    @Override
    public Object[] getDefinedProperties() {
        return this.defineProperties;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    public String toString() {
        return "ConstructorPropertyMeta{owner=" + this.getOwnerType() + ", constructorParameter=" + this.parameter + "}";
    }

    @Override
    public ConstructorPropertyMeta<T, P> withReflectionService(ReflectionService reflectionService) {
        return new ConstructorPropertyMeta<T, P>(this.getName(), this.getOwnerType(), reflectionService, this.parameter, this.scoredGetter, this.scoredSetter, this.instantiatorDefinition, this.defineProperties);
    }
}

