/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.IndexedBooleanArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedByteArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedCharArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedDoubleArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedFloatArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedIntArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedListGetter;
import org.simpleflatmapper.reflect.getter.IndexedLongArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedObjectArrayGetter;
import org.simpleflatmapper.reflect.getter.IndexedShortArrayGetter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ArrayPropertyFinder;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.AppendCollectionSetter;
import org.simpleflatmapper.reflect.setter.IndexedBooleanArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedByteArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedCharArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedDoubleArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedFloatArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedIntArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedListSetter;
import org.simpleflatmapper.reflect.setter.IndexedLongArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedObjectArraySetter;
import org.simpleflatmapper.reflect.setter.IndexedShortArraySetter;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.BooleanSupplier;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.IntFactory;
import org.simpleflatmapper.util.TypeHelper;

public class ArrayClassMeta<T, E>
implements ClassMeta<T> {
    private final ReflectionService reflectionService;
    private final Type elementTarget;
    private final ClassMeta<E> elementClassMeta;
    private final Type type;
    private final InstantiatorDefinitionAndIntermediatType instInfo;
    private final boolean needTransformer;
    private static final List<InstantiatorDefinitionAndIntermediatTypeFactory> intermediatTypeFactories = new ArrayList<InstantiatorDefinitionAndIntermediatTypeFactory>();

    public ArrayClassMeta(Type type, Type elementTarget, ReflectionService reflectionService, InstantiatorDefinitionAndIntermediatType typeInfo) {
        this.type = type;
        this.elementTarget = elementTarget;
        this.reflectionService = reflectionService;
        this.needTransformer = typeInfo.needTransform;
        this.elementClassMeta = reflectionService.getClassMeta(elementTarget);
        this.instInfo = typeInfo;
    }

    public ArrayClassMeta(Type type, Type elementTarget, ReflectionService reflectionService, boolean needTransformer, ClassMeta<E> elementClassMeta, InstantiatorDefinitionAndIntermediatType instInfo) {
        this.reflectionService = reflectionService;
        this.elementTarget = elementTarget;
        this.elementClassMeta = elementClassMeta;
        this.type = type;
        this.instInfo = instInfo;
        this.needTransformer = needTransformer;
    }

    public ArrayClassMeta<T, E> withReflectionService(ReflectionService reflectionService) {
        return new ArrayClassMeta(this.type, this.elementTarget, reflectionService, this.needTransformer, reflectionService.getClassMeta(this.elementClassMeta.getType()), this.instInfo);
    }

    public ClassMeta<E> getElementClassMeta() {
        return this.elementClassMeta;
    }

    public Type getElementTarget() {
        return this.elementTarget;
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<T> newPropertyFinder() {
        return new ArrayPropertyFinder(this, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        if (this.instInfo.instantiatorDefinition != null) {
            return Arrays.asList(this.instInfo.instantiatorDefinition);
        }
        return Collections.emptyList();
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        throw new UnsupportedOperationException("Cannot forEach property on array as variable");
    }

    @Override
    public int getNumberOfProperties() {
        return 10000;
    }

    @Override
    public boolean needTransformer() {
        return this.needTransformer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, E> IntFactory<Setter<T, E>> newSetterFactory(final BooleanSupplier appendSetter) {
        if (TypeHelper.isArray((Type)this.type)) {
            if (!TypeHelper.isPrimitive((Type)this.elementTarget)) return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return new IndexedObjectArraySetter(i);
                }
            };
            if (Boolean.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedBooleanArraySetter(i);
                    }
                };
            }
            if (Byte.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedByteArraySetter(i);
                    }
                };
            }
            if (Character.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedCharArraySetter(i);
                    }
                };
            }
            if (Short.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedShortArraySetter(i);
                    }
                };
            }
            if (Integer.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedIntArraySetter(i);
                    }
                };
            }
            if (Long.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedLongArraySetter(i);
                    }
                };
            }
            if (Float.TYPE.equals(this.elementTarget)) {
                return new IntFactory<Setter<T, E>>(){

                    public Setter<T, E> newInstance(int i) {
                        return new IndexedFloatArraySetter(i);
                    }
                };
            }
            if (!Double.TYPE.equals(this.elementTarget)) return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return NullSetter.NULL_SETTER;
                }
            };
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    return new IndexedDoubleArraySetter(i);
                }
            };
        }
        if (TypeHelper.isAssignable(List.class, (Type)this.instInfo.intermediateType)) {
            return new IntFactory<Setter<T, E>>(){

                public Setter<T, E> newInstance(int i) {
                    if (appendSetter.getAsBoolean() && i == 0) {
                        return AppendCollectionSetter.INSTANCE;
                    }
                    return new IndexedListSetter(i);
                }
            };
        }
        if (!TypeHelper.isAssignable(Collection.class, (Type)this.instInfo.intermediateType)) return new /* invalid duplicate definition of identical inner class */;
        return new IntFactory<Setter<T, E>>(){

            public Setter<T, E> newInstance(int i) {
                return AppendCollectionSetter.INSTANCE;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, E> IntFactory<Getter<T, E>> newGetterFactory() {
        if (TypeHelper.isArray((Type)this.type)) {
            Type elementType = TypeHelper.getComponentTypeOfListOrArray((Type)this.type);
            if (!TypeHelper.isPrimitive((Type)elementType)) return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return new IndexedObjectArrayGetter(i);
                }
            };
            if (Boolean.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedBooleanArrayGetter(i);
                    }
                };
            }
            if (Byte.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedByteArrayGetter(i);
                    }
                };
            }
            if (Character.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedCharArrayGetter(i);
                    }
                };
            }
            if (Short.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedShortArrayGetter(i);
                    }
                };
            }
            if (Integer.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedIntArrayGetter(i);
                    }
                };
            }
            if (Long.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedLongArrayGetter(i);
                    }
                };
            }
            if (Float.TYPE.equals(elementType)) {
                return new IntFactory<Getter<T, E>>(){

                    public Getter<T, E> newInstance(int i) {
                        return new IndexedFloatArrayGetter(i);
                    }
                };
            }
            if (!Double.TYPE.equals(elementType)) return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return NullGetter.getter();
                }
            };
            return new IntFactory<Getter<T, E>>(){

                public Getter<T, E> newInstance(int i) {
                    return new IndexedDoubleArrayGetter(i);
                }
            };
        }
        if (!TypeHelper.isAssignable(List.class, (Type)this.instInfo.intermediateType)) return new /* invalid duplicate definition of identical inner class */;
        return new IntFactory<Getter<T, E>>(){

            public Getter<T, E> newInstance(int i) {
                return new IndexedListGetter(i);
            }
        };
    }

    public static boolean supports(Type target) {
        Class clazz = TypeHelper.toClass((Type)target);
        for (InstantiatorDefinitionAndIntermediatTypeFactory factory : intermediatTypeFactories) {
            if (!factory.supports(target)) continue;
            return true;
        }
        return Collection.class.isAssignableFrom(clazz) || Iterable.class.equals((Object)clazz);
    }

    public static <T, E> ArrayClassMeta<T, E> of(Type type, Type elementTarget, ReflectionService reflectionService) {
        InstantiatorDefinitionAndIntermediatType typeInfo = ArrayClassMeta.getTypeInfo(type);
        return new ArrayClassMeta<T, E>(type, elementTarget, reflectionService, typeInfo);
    }

    public static InstantiatorDefinitionAndIntermediatType getTypeInfo(Type type) {
        for (InstantiatorDefinitionAndIntermediatTypeFactory factory : intermediatTypeFactories) {
            if (!factory.supports(type)) continue;
            return factory.newTypeInfo(type);
        }
        Class clazz = TypeHelper.toClass((Type)type);
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            return new InstantiatorDefinitionAndIntermediatType(ArrayClassMeta.getConstructor(type), type, false);
        }
        throw new IllegalArgumentException("Unknown List impl for " + type);
    }

    private static InstantiatorDefinition getConstructor(Type type) {
        if (TypeHelper.isArray((Type)type)) {
            return null;
        }
        try {
            return new ExecutableInstantiatorDefinition(TypeHelper.toClass((Type)type).getDeclaredConstructor(new Class[0]), new Parameter[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + type);
        }
    }

    static {
        intermediatTypeFactories.add(new InstantiatorDefinitionAndIntermediatTypeFactory(){

            @Override
            public boolean supports(Type type) {
                return TypeHelper.isArray((Type)type);
            }

            @Override
            public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type type) {
                return new InstantiatorDefinitionAndIntermediatType(null, type, false);
            }
        });
        intermediatTypeFactories.add(new InstantiatorDefinitionAndIntermediatTypeFactory(){

            @Override
            public boolean supports(Type type) {
                return TypeHelper.areEquals((Type)type, List.class) || TypeHelper.areEquals((Type)type, Collection.class) || TypeHelper.areEquals((Type)type, Iterable.class);
            }

            @Override
            public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type type) {
                return new InstantiatorDefinitionAndIntermediatType(ArrayClassMeta.getConstructor(ArrayList.class), (Type)((Object)ArrayList.class), false);
            }
        });
        intermediatTypeFactories.add(new InstantiatorDefinitionAndIntermediatTypeFactory(){

            @Override
            public boolean supports(Type type) {
                return TypeHelper.areEquals((Type)type, Set.class);
            }

            @Override
            public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type type) {
                return new InstantiatorDefinitionAndIntermediatType(ArrayClassMeta.getConstructor(HashSet.class), (Type)((Object)HashSet.class), false);
            }
        });
        intermediatTypeFactories.add(new InstantiatorDefinitionAndIntermediatTypeFactory(){

            @Override
            public boolean supports(Type type) {
                return "org.eclipse.collections.api.list.MutableList".equals(TypeHelper.toClass((Type)type).getName());
            }

            @Override
            public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type type) {
                try {
                    Class<?> clazz = type.getClass().getClassLoader().loadClass("org.eclipse.collections.impl.list.mutable.FastList");
                    return new InstantiatorDefinitionAndIntermediatType(ArrayClassMeta.getConstructor(clazz), clazz, false);
                }
                catch (ClassNotFoundException e) {
                    return (InstantiatorDefinitionAndIntermediatType)ErrorHelper.rethrow((Throwable)e);
                }
            }
        });
        intermediatTypeFactories.add(new InstantiatorDefinitionAndIntermediatTypeFactory(){

            @Override
            public boolean supports(Type type) {
                return "org.eclipse.collections.api.list.ImmutableList".equals(TypeHelper.toClass((Type)type).getName());
            }

            @Override
            public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type type) {
                try {
                    Class<?> clazz = TypeHelper.toClass((Type)type).getClassLoader().loadClass("org.eclipse.collections.impl.list.mutable.FastList");
                    return new InstantiatorDefinitionAndIntermediatType(new BuilderInstantiatorDefinition(ArrayClassMeta.getConstructor(clazz), new HashMap<Parameter, Method>(), clazz.getMethod("toImmutable", new Class[0])), clazz, true);
                }
                catch (ClassNotFoundException e) {
                    return (InstantiatorDefinitionAndIntermediatType)ErrorHelper.rethrow((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    return (InstantiatorDefinitionAndIntermediatType)ErrorHelper.rethrow((Throwable)e);
                }
            }
        });
        intermediatTypeFactories.add(new InstantiatorDefinitionAndIntermediatTypeFactory(){

            @Override
            public boolean supports(Type type) {
                return "com.google.common.collect.ImmutableList".equals(TypeHelper.toClass((Type)type).getName());
            }

            @Override
            public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type type) {
                try {
                    Class<?> builderClass = type.getClass().getClassLoader().loadClass("com.google.common.collect.ImmutableList");
                    return new InstantiatorDefinitionAndIntermediatType(new BuilderInstantiatorDefinition(ArrayClassMeta.getConstructor(ArrayList.class), new HashMap<Parameter, Method>(), builderClass.getMethod("copyOf", Collection.class)), (Type)((Object)ArrayList.class), true);
                }
                catch (ClassNotFoundException e) {
                    return (InstantiatorDefinitionAndIntermediatType)ErrorHelper.rethrow((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    return (InstantiatorDefinitionAndIntermediatType)ErrorHelper.rethrow((Throwable)e);
                }
            }
        });
    }

    public static interface InstantiatorDefinitionAndIntermediatTypeFactory {
        public boolean supports(Type var1);

        public InstantiatorDefinitionAndIntermediatType newTypeInfo(Type var1);
    }

    public static class InstantiatorDefinitionAndIntermediatType {
        public final InstantiatorDefinition instantiatorDefinition;
        public final Type intermediateType;
        public final boolean needTransform;

        public InstantiatorDefinitionAndIntermediatType(InstantiatorDefinition instantiatorDefinition, Type intermediateType, boolean needTransform) {
            this.instantiatorDefinition = instantiatorDefinition;
            this.intermediateType = intermediateType;
            this.needTransform = needTransform;
        }
    }
}

