/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.instantiator;

import java.util.Comparator;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.TypeAffinity;
import org.simpleflatmapper.util.TypeHelper;

public class InstantiatorDefinitions {
    public static final Comparator<InstantiatorDefinition> COMPARATOR = new Comparator<InstantiatorDefinition>(){

        @Override
        public int compare(InstantiatorDefinition o1, InstantiatorDefinition o2) {
            int p;
            InstantiatorDefinition.Type t1 = o1.getType();
            InstantiatorDefinition.Type t2 = o2.getType();
            int d = t1.ordinal() - t2.ordinal();
            if (d != 0) {
                return d;
            }
            if (InstantiatorDefinitions.isValueOf(o1)) {
                if (!InstantiatorDefinitions.isValueOf(o2)) {
                    return -1;
                }
            } else if (InstantiatorDefinitions.isValueOf(o2)) {
                return 1;
            }
            if ((p = o1.getParameters().length - o2.getParameters().length) == 0) {
                return o1.getName().compareTo(o2.getName());
            }
            return p;
        }
    };

    private static boolean isValueOf(InstantiatorDefinition d) {
        if (d.getType() != InstantiatorDefinition.Type.METHOD) {
            return false;
        }
        String name = d.getName();
        return name.equals("valueOf") || name.equals("of") || name.equals("newInstance");
    }

    public static InstantiatorDefinition lookForCompatibleOneArgument(List<InstantiatorDefinition> col, CompatibilityScorer scorer) {
        if (col == null) {
            return null;
        }
        InstantiatorDefinition current = null;
        int currentScore = -1;
        for (int i = 0; i < col.size(); ++i) {
            int score;
            InstantiatorDefinition id = col.get(i);
            if (id.getParameters().length != 1 || (score = scorer.score(id)) <= currentScore) continue;
            current = id;
            currentScore = score;
        }
        return current;
    }

    public static CompatibilityScorer getCompatibilityScorer(Object key) {
        TypeAffinity ta;
        Class[] affinities;
        if (key instanceof TypeAffinity && (affinities = (ta = (TypeAffinity)key).getAffinities()) != null && affinities.length > 0) {
            return new TypeAffinityCompatibilityScorer(affinities);
        }
        return new DefaultCompatibilityScorer();
    }

    public static interface CompatibilityScorer {
        public int score(InstantiatorDefinition var1);
    }

    private static class TypeAffinityCompatibilityScorer
    implements CompatibilityScorer {
        private final Class<?>[] classes;

        private TypeAffinityCompatibilityScorer(Class<?>[] classes) {
            this.classes = classes;
        }

        @Override
        public int score(InstantiatorDefinition id) {
            Class paramType = TypeHelper.toBoxedClass(id.getParameters()[0].getType());
            for (int i = 0; i < this.classes.length; ++i) {
                Class<?> c = this.classes[i];
                if (!c.isAssignableFrom(paramType)) continue;
                return this.classes.length - i + 10;
            }
            Package aPackage = paramType.getPackage();
            if (aPackage != null && aPackage.getName().equals("java.lang")) {
                return 1;
            }
            return 0;
        }
    }

    private static class DefaultCompatibilityScorer
    implements CompatibilityScorer {
        private DefaultCompatibilityScorer() {
        }

        @Override
        public int score(InstantiatorDefinition id) {
            Class<?> type = id.getParameters()[0].getType();
            Package aPackage = type.getPackage();
            if (type.isPrimitive() || aPackage != null && aPackage.getName().equals("java.lang")) {
                return 1;
            }
            return 0;
        }
    }
}

