/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.SelectQuery;
import org.simpleflatmapper.util.CheckedConsumer;

public class SelectQueryImpl<T, P>
implements SelectQuery<T, P> {
    private final QueryPreparer<P> queryPreparer;
    private final JdbcMapper<T> mapper;

    public SelectQueryImpl(QueryPreparer<P> queryPreparer, JdbcMapper<T> mapper) {
        this.queryPreparer = queryPreparer;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T readFirst(Connection connection, P p) throws SQLException {
        PreparedStatement preparedStatement = this.queryPreparer.prepare(connection).bind(p);
        try {
            ResultSet rs;
            block8: {
                T t;
                rs = preparedStatement.executeQuery();
                try {
                    if (!rs.next()) break block8;
                    t = this.mapper.map(rs);
                    this.safeClose(rs);
                }
                catch (Throwable throwable) {
                    this.safeClose(rs);
                    throw throwable;
                }
                return t;
            }
            T t = null;
            this.safeClose(rs);
            return t;
        }
        finally {
            this.safeClose(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends CheckedConsumer<? super T>> C read(Connection connection, P p, C consumer) throws SQLException {
        PreparedStatement preparedStatement = this.queryPreparer.prepare(connection).bind(p);
        try {
            ResultSet rs = preparedStatement.executeQuery();
            try {
                this.mapper.forEach(rs, consumer);
            }
            finally {
                this.safeClose(rs);
            }
        }
        finally {
            this.safeClose(preparedStatement);
        }
        return consumer;
    }

    private void safeClose(PreparedStatement preparedStatement) {
        try {
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void safeClose(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

