/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;

public class ObjectToJavaZonedDateTimeConverter
implements ContextualConverter<Object, ZonedDateTime> {
    private final ZoneId zone;

    public ObjectToJavaZonedDateTimeConverter(ZoneId zoneId) {
        this.zone = zoneId;
    }

    @Override
    public ZonedDateTime convert(Object o, Context context) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return Instant.ofEpochMilli(((Date)o).getTime()).atZone(this.zone);
        }
        if (o instanceof Instant) {
            return ((Instant)o).atZone(this.zone);
        }
        if (o instanceof ZonedDateTime) {
            return (ZonedDateTime)o;
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).atZone(this.zone);
        }
        if (o instanceof TemporalAccessor) {
            return ZonedDateTime.from((TemporalAccessor)o).withZoneSameLocal(this.zone);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(o) + " to ZonedDateTime");
    }
}

