/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.log;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.LogLevel;
import org.openqa.selenium.bidi.log.StackTrace;
import org.openqa.selenium.bidi.script.Source;
import org.openqa.selenium.json.JsonInput;

public class JavascriptLogEntry
extends GenericLogEntry {
    private final String type;

    public JavascriptLogEntry(LogLevel level, Source source, String text, long timestamp, String type, @Nullable StackTrace stackTrace) {
        super(level, source, text, timestamp, "javascript", stackTrace);
        this.type = "javascript";
    }

    @Override
    public String getType() {
        return this.type;
    }

    public static JavascriptLogEntry fromJson(JsonInput input) {
        LogLevel level = null;
        Source source = null;
        String text = null;
        long timestamp = 0L;
        String type = null;
        StackTrace stackTrace = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "level": {
                    level = (LogLevel)((Object)input.read(LogLevel.class));
                    continue block16;
                }
                case "source": {
                    source = (Source)input.read(Source.class);
                    continue block16;
                }
                case "text": {
                    text = (String)input.read(String.class);
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block16;
                }
                case "type": {
                    type = (String)input.read(String.class);
                    continue block16;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new JavascriptLogEntry(level, source, text, timestamp, type, stackTrace);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("type", this.type);
        toReturn.put("level", (Object)super.getLevel());
        toReturn.put("text", super.getText());
        toReturn.put("timestamp", super.getTimestamp());
        if (this.getStackTrace() != null) {
            toReturn.put("stackTrace", this.getStackTrace());
        }
        return Collections.unmodifiableMap(toReturn);
    }
}

