/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.css.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class FontVariationAxis {
    private final String tag;
    private final String name;
    private final Number minValue;
    private final Number maxValue;
    private final Number defaultValue;

    public FontVariationAxis(String tag, String name, Number minValue, Number maxValue, Number defaultValue) {
        this.tag = Objects.requireNonNull(tag, "tag is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.minValue = Objects.requireNonNull(minValue, "minValue is required");
        this.maxValue = Objects.requireNonNull(maxValue, "maxValue is required");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is required");
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    private static FontVariationAxis fromJson(JsonInput input) {
        String tag = null;
        String name = null;
        Number minValue = 0;
        Number maxValue = 0;
        Number defaultValue = 0;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "tag": {
                    tag = input.nextString();
                    continue block14;
                }
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "minValue": {
                    minValue = input.nextNumber();
                    continue block14;
                }
                case "maxValue": {
                    maxValue = input.nextNumber();
                    continue block14;
                }
                case "defaultValue": {
                    defaultValue = input.nextNumber();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FontVariationAxis(tag, name, minValue, maxValue, defaultValue);
    }
}

