/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.layertree.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v129.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v129.layertree.model.LayerId;
import org.openqa.selenium.devtools.v129.layertree.model.ScrollRect;
import org.openqa.selenium.devtools.v129.layertree.model.StickyPositionConstraint;
import org.openqa.selenium.json.JsonInput;

public class Layer {
    private final LayerId layerId;
    private final Optional<LayerId> parentLayerId;
    private final Optional<BackendNodeId> backendNodeId;
    private final Number offsetX;
    private final Number offsetY;
    private final Number width;
    private final Number height;
    private final Optional<List<Number>> transform;
    private final Optional<Number> anchorX;
    private final Optional<Number> anchorY;
    private final Optional<Number> anchorZ;
    private final Integer paintCount;
    private final Boolean drawsContent;
    private final Optional<Boolean> invisible;
    private final Optional<List<ScrollRect>> scrollRects;
    private final Optional<StickyPositionConstraint> stickyPositionConstraint;

    public Layer(LayerId layerId, Optional<LayerId> parentLayerId, Optional<BackendNodeId> backendNodeId, Number offsetX, Number offsetY, Number width, Number height, Optional<List<Number>> transform, Optional<Number> anchorX, Optional<Number> anchorY, Optional<Number> anchorZ, Integer paintCount, Boolean drawsContent, Optional<Boolean> invisible, Optional<List<ScrollRect>> scrollRects, Optional<StickyPositionConstraint> stickyPositionConstraint) {
        this.layerId = Objects.requireNonNull(layerId, "layerId is required");
        this.parentLayerId = parentLayerId;
        this.backendNodeId = backendNodeId;
        this.offsetX = Objects.requireNonNull(offsetX, "offsetX is required");
        this.offsetY = Objects.requireNonNull(offsetY, "offsetY is required");
        this.width = Objects.requireNonNull(width, "width is required");
        this.height = Objects.requireNonNull(height, "height is required");
        this.transform = transform;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.anchorZ = anchorZ;
        this.paintCount = Objects.requireNonNull(paintCount, "paintCount is required");
        this.drawsContent = Objects.requireNonNull(drawsContent, "drawsContent is required");
        this.invisible = invisible;
        this.scrollRects = scrollRects;
        this.stickyPositionConstraint = stickyPositionConstraint;
    }

    public LayerId getLayerId() {
        return this.layerId;
    }

    public Optional<LayerId> getParentLayerId() {
        return this.parentLayerId;
    }

    public Optional<BackendNodeId> getBackendNodeId() {
        return this.backendNodeId;
    }

    public Number getOffsetX() {
        return this.offsetX;
    }

    public Number getOffsetY() {
        return this.offsetY;
    }

    public Number getWidth() {
        return this.width;
    }

    public Number getHeight() {
        return this.height;
    }

    public Optional<List<Number>> getTransform() {
        return this.transform;
    }

    public Optional<Number> getAnchorX() {
        return this.anchorX;
    }

    public Optional<Number> getAnchorY() {
        return this.anchorY;
    }

    public Optional<Number> getAnchorZ() {
        return this.anchorZ;
    }

    public Integer getPaintCount() {
        return this.paintCount;
    }

    public Boolean getDrawsContent() {
        return this.drawsContent;
    }

    public Optional<Boolean> getInvisible() {
        return this.invisible;
    }

    public Optional<List<ScrollRect>> getScrollRects() {
        return this.scrollRects;
    }

    public Optional<StickyPositionConstraint> getStickyPositionConstraint() {
        return this.stickyPositionConstraint;
    }

    private static Layer fromJson(JsonInput input) {
        LayerId layerId = null;
        Optional<LayerId> parentLayerId = Optional.empty();
        Optional<BackendNodeId> backendNodeId = Optional.empty();
        Number offsetX = 0;
        Number offsetY = 0;
        Number width = 0;
        Number height = 0;
        Optional<List<Number>> transform = Optional.empty();
        Optional<Number> anchorX = Optional.empty();
        Optional<Number> anchorY = Optional.empty();
        Optional<Number> anchorZ = Optional.empty();
        Integer paintCount = 0;
        Boolean drawsContent = false;
        Optional<Boolean> invisible = Optional.empty();
        Optional<List<ScrollRect>> scrollRects = Optional.empty();
        Optional<StickyPositionConstraint> stickyPositionConstraint = Optional.empty();
        input.beginObject();
        block36: while (input.hasNext()) {
            switch (input.nextName()) {
                case "layerId": {
                    layerId = (LayerId)input.read(LayerId.class);
                    continue block36;
                }
                case "parentLayerId": {
                    parentLayerId = Optional.ofNullable((LayerId)input.read(LayerId.class));
                    continue block36;
                }
                case "backendNodeId": {
                    backendNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block36;
                }
                case "offsetX": {
                    offsetX = input.nextNumber();
                    continue block36;
                }
                case "offsetY": {
                    offsetY = input.nextNumber();
                    continue block36;
                }
                case "width": {
                    width = input.nextNumber();
                    continue block36;
                }
                case "height": {
                    height = input.nextNumber();
                    continue block36;
                }
                case "transform": {
                    transform = Optional.ofNullable(input.readArray(Number.class));
                    continue block36;
                }
                case "anchorX": {
                    anchorX = Optional.ofNullable(input.nextNumber());
                    continue block36;
                }
                case "anchorY": {
                    anchorY = Optional.ofNullable(input.nextNumber());
                    continue block36;
                }
                case "anchorZ": {
                    anchorZ = Optional.ofNullable(input.nextNumber());
                    continue block36;
                }
                case "paintCount": {
                    paintCount = input.nextNumber().intValue();
                    continue block36;
                }
                case "drawsContent": {
                    drawsContent = input.nextBoolean();
                    continue block36;
                }
                case "invisible": {
                    invisible = Optional.ofNullable(input.nextBoolean());
                    continue block36;
                }
                case "scrollRects": {
                    scrollRects = Optional.ofNullable(input.readArray(ScrollRect.class));
                    continue block36;
                }
                case "stickyPositionConstraint": {
                    stickyPositionConstraint = Optional.ofNullable((StickyPositionConstraint)input.read(StickyPositionConstraint.class));
                    continue block36;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Layer(layerId, parentLayerId, backendNodeId, offsetX, offsetY, width, height, transform, anchorX, anchorY, anchorZ, paintCount, drawsContent, invisible, scrollRects, stickyPositionConstraint);
    }
}

