/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.domstorage.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v123.domstorage.model.SerializedStorageKey;
import org.openqa.selenium.json.JsonInput;

public class StorageId {
    private final Optional<String> securityOrigin;
    private final Optional<SerializedStorageKey> storageKey;
    private final Boolean isLocalStorage;

    public StorageId(Optional<String> securityOrigin, Optional<SerializedStorageKey> storageKey, Boolean isLocalStorage) {
        this.securityOrigin = securityOrigin;
        this.storageKey = storageKey;
        this.isLocalStorage = Objects.requireNonNull(isLocalStorage, "isLocalStorage is required");
    }

    public Optional<String> getSecurityOrigin() {
        return this.securityOrigin;
    }

    public Optional<SerializedStorageKey> getStorageKey() {
        return this.storageKey;
    }

    public Boolean getIsLocalStorage() {
        return this.isLocalStorage;
    }

    private static StorageId fromJson(JsonInput input) {
        Optional<String> securityOrigin = Optional.empty();
        Optional<SerializedStorageKey> storageKey = Optional.empty();
        Boolean isLocalStorage = false;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "securityOrigin": {
                    securityOrigin = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "storageKey": {
                    storageKey = Optional.ofNullable((SerializedStorageKey)input.read(SerializedStorageKey.class));
                    continue block10;
                }
                case "isLocalStorage": {
                    isLocalStorage = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StorageId(securityOrigin, storageKey, isLocalStorage);
    }
}

