/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_cs;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven.ScalaMojoSupport;
import org_scala_tools_maven_executions.JavaMainCallerByFork;
import org_scala_tools_maven_executions.MainHelper;
import org_scala_tools_maven_executions.SpawnMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalacsClient {
    public static final String BOOT_PROP_RSRC = "scalacs.boot.properties";
    public static Pattern linePattern = Pattern.compile("^-(INFO|WARN|ERROR)\t([^\t]*)\t([^\t]*)\t(.*)$");
    public static Pattern locationPattern = Pattern.compile("([^#]*)#(\\d+),(\\d+),(\\d+),(\\d+)");
    private Log _log;
    private ScalaMojoSupport _mojo;
    private String[] _jvmArgs;
    private String _csGroupId;
    private String _csArtifactId;
    private String _csVersion;

    public ScalacsClient(ScalaMojoSupport mojo, String csGroupId, String csArtifactId, String csVersion, String[] jvmArgs) {
        this._log = mojo.getLog();
        this._mojo = mojo;
        this._csGroupId = csGroupId;
        this._csArtifactId = csArtifactId;
        this._csVersion = csVersion;
        this._jvmArgs = jvmArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEvent> parse(String response) throws Exception {
        LinkedList<LogEvent> back = new LinkedList<LogEvent>();
        BufferedReader in = new BufferedReader(new StringReader(response));
        try {
            String l = in.readLine();
            while (l != null) {
                Matcher m = linePattern.matcher(l);
                if (m.matches()) {
                    LogEvent e = new LogEvent();
                    e.level = Level.valueOf(m.group(1).toUpperCase());
                    e.category = m.group(2);
                    e.text = m.group(4).replace('$', '\n');
                    Matcher ml = locationPattern.matcher(m.group(3));
                    if (ml.matches()) {
                        e.file = new File(ml.group(1));
                        e.line = Integer.parseInt(m.group(2));
                        e.column = Integer.parseInt(m.group(3));
                        e.offset = Integer.parseInt(m.group(4));
                        e.length = Integer.parseInt(m.group(5));
                    }
                    back.add(e);
                }
                l = in.readLine();
            }
        }
        finally {
            IOUtil.close((Reader)in);
        }
        return back;
    }

    public String sendRequestCreateOrUpdate(String yamlDef) throws Exception {
        String back = "";
        try {
            back = this.sendRequest("createOrUpdate", yamlDef);
        }
        catch (ConnectException exc) {
            this.startNewServer();
            back = this.sendRequest("createOrUpdate", yamlDef);
        }
        return back;
    }

    public String sendRequestRemove(String projectName) throws Exception {
        return this.sendRequest("remove?p=" + projectName, null);
    }

    public String sendRequestCompile(String projectName, boolean withDependencies, boolean withDependent) throws Exception {
        StringBuilder query = new StringBuilder("compile");
        if (StringUtils.isNotEmpty((String)projectName)) {
            query.append("?p=").append(projectName);
            if (!withDependencies) {
                query.append("&noDependencies=true");
            }
            if (!withDependent) {
                query.append("&noDependent=true");
            }
        }
        return this.sendRequest(query.toString(), null);
    }

    public String sendRequestClean() throws Exception {
        return this.sendRequest("clean", null);
    }

    public String sendRequestStop() throws Exception {
        return this.sendRequest("stop", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendRequest(String action, String data) throws Exception {
        URL url = new URL("http://127.0.0.1:27616/" + action);
        this.traceUrl(url);
        URLConnection cnx = url.openConnection();
        cnx.setDoOutput(StringUtils.isNotEmpty((String)data));
        cnx.setDoInput(true);
        if (StringUtils.isNotEmpty((String)data)) {
            OutputStream os = cnx.getOutputStream();
            try {
                IOUtil.copy((Reader)new StringReader(data), (OutputStream)os);
            }
            finally {
                IOUtil.close((OutputStream)os);
            }
        }
        InputStream is = cnx.getInputStream();
        try {
            String back;
            String string = back = IOUtil.toString((InputStream)is);
            return string;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    public void traceUrl(URL url) throws Exception {
        String msg = "request : " + url;
        if (this._mojo.displayCmd) {
            this._log.info((CharSequence)msg);
        } else {
            this._log.debug((CharSequence)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewServer() throws Exception {
        this._log.info((CharSequence)"start scala-tools-server...");
        HashSet<String> classpath = new HashSet<String>();
        this._mojo.addToClasspath("org.scala-tools.sbt", "sbt-launch", "0.7.2", classpath, true);
        String[] jvmArgs = new String[this._jvmArgs == null ? 1 : this._jvmArgs.length + 1];
        File installDir = new File(System.getProperty("user.home"), ".sbt-launch");
        jvmArgs[0] = "-Dsbt.boot.properties=" + this.installConf(new File(installDir, this._csArtifactId + "-" + this._csVersion + ".boot.properties")).getCanonicalPath();
        if (this._jvmArgs != null) {
            System.arraycopy(this._jvmArgs, 0, jvmArgs, 1, this._jvmArgs.length);
        }
        FileTailer tailer = new FileTailer(new File(installDir, "update.log"));
        boolean started = false;
        try {
            JavaMainCallerByFork jcmd = new JavaMainCallerByFork(this._mojo, "xsbt.boot.Boot", MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()])), jvmArgs, null, false);
            SpawnMonitor mon = jcmd.spawn(this._mojo.displayCmd);
            for (int i = 60; i > 0 && !started && mon.isRunning(); --i) {
                try {
                    if (this._mojo.displayCmd) {
                        System.out.print(tailer.whatNew());
                    } else {
                        System.out.print(".");
                    }
                    Thread.sleep(1000L);
                    this.sendRequest("ping", null);
                    started = true;
                    continue;
                }
                catch (ConnectException exc) {
                    started = false;
                }
            }
            if (this._mojo.displayCmd) {
                System.out.print(tailer.whatNew());
            }
            System.out.println("");
        }
        finally {
            tailer.close();
        }
        if (!started) {
            throw new IllegalStateException("can't start and connect to scalacs");
        }
        this._mojo.getLog().info((CharSequence)"scalacs connected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File installConf(File scalaCsBootConf) throws Exception {
        block5: {
            if (scalaCsBootConf.isFile()) break block5;
            scalaCsBootConf.getParentFile().mkdirs();
            InputStream is = null;
            StringWriter sw = new StringWriter();
            try {
                is = this.getClass().getResourceAsStream(BOOT_PROP_RSRC);
                if (is == null) {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(BOOT_PROP_RSRC);
                }
                if (is == null) {
                    String abspath = "/" + this.getClass().getPackage().getName().replace('.', '/') + "/" + BOOT_PROP_RSRC;
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(abspath);
                    if (is == null) {
                        throw new IllegalStateException("can't find " + abspath + " in the classpath");
                    }
                }
                IOUtil.copy((InputStream)is, (Writer)sw);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                IOUtil.close((Writer)sw);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
            IOUtil.close((Writer)sw);
            Properties p = new Properties(System.getProperties());
            p.setProperty("scalacs.groupId", this._csGroupId);
            p.setProperty("scalacs.artifactId", this._csArtifactId);
            p.setProperty("scalacs.version", this._csVersion);
            p.setProperty("scalacs.directory", scalaCsBootConf.getParentFile().getCanonicalPath());
            String cfg = StringUtils.interpolate((String)sw.toString(), (Map)p);
            FileUtils.fileWrite((String)scalaCsBootConf.getCanonicalPath(), (String)"UTF-8", (String)cfg);
        }
        return scalaCsBootConf;
    }

    private static class FileTailer {
        private long _filePointer;
        private RandomAccessFile _raf;
        private File _file;

        public FileTailer(File f) throws Exception {
            this._file = f;
            this._filePointer = f.length();
            this._raf = null;
        }

        public CharSequence whatNew() throws Exception {
            StringBuilder back = new StringBuilder();
            if (this._raf == null && this._file.isFile()) {
                this._raf = new RandomAccessFile(this._file, "r");
            }
            if (this._raf != null) {
                long fileLength = this._file.length();
                if (fileLength < this._filePointer) {
                    this.close();
                    this._raf = new RandomAccessFile(this._file, "r");
                    this._filePointer = 0L;
                }
                if (fileLength > this._filePointer) {
                    this._raf.seek(this._filePointer);
                    String line = null;
                    while ((line = this._raf.readLine()) != null) {
                        back.append(line).append('\n');
                    }
                    this._filePointer = this._raf.getFilePointer();
                }
            }
            return back;
        }

        public void close() {
            try {
                if (this._raf != null) {
                    this._raf.close();
                    this._raf = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class LogEvent {
        public Level level = Level.INFO;
        public String category = "";
        public File file = null;
        public int line = 0;
        public int column = 0;
        public int offset = 0;
        public int length = 0;
        public CharSequence text = "";

        public String toString() {
            return (Object)((Object)this.level) + "*" + this.category + "*" + this.file + "*" + this.line + "*" + this.column + "*" + this.offset + "*" + this.length + "*" + this.text + "*";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

