/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.view.facelets.html;

import java.io.IOException;
import java.util.Iterator;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.validator.Validator;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import org.richfaces.component.AbstractGraphValidator;

public class GraphValidatorHandler
extends ComponentHandler {
    private static final String BUILT_IN_BEAN_VALIDATOR_ATTRIBUTE_NAME = GraphValidatorHandler.class.getName() + ":BUILT_IN_BEAN_VALIDATOR_ATTRIBUTE_NAME";

    public GraphValidatorHandler(ComponentConfig config) {
        super(config);
    }

    private Validator getBuiltInBeanValidator(FacesContext context) {
        Validator result = (Validator)context.getAttributes().get(BUILT_IN_BEAN_VALIDATOR_ATTRIBUTE_NAME);
        if (result == null) {
            result = context.getApplication().createValidator("javax.faces.Bean");
            context.getAttributes().put(BUILT_IN_BEAN_VALIDATOR_ATTRIBUTE_NAME, result);
        }
        return result;
    }

    private void setupValidators(FacesContext context, UIComponent component, Validator validator) {
        if (component.getChildCount() == 0 && component.getFacetCount() == 0) {
            return;
        }
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)child;
                this.setupValidator(context, input, validator);
            }
            if (child instanceof AbstractGraphValidator) continue;
            this.setupValidators(context, child, validator);
        }
    }

    private void setupValidator(FacesContext context, EditableValueHolder input, Validator beanValidator) {
        boolean addBeanValidator = true;
        Class<?> validatorToRemoveClass = this.getBuiltInBeanValidator(context).getClass();
        Validator validatorToRemove = null;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator nextValidator = validators[i];
            if (nextValidator.getClass().equals(beanValidator.getClass())) {
                addBeanValidator = false;
                continue;
            }
            if (!nextValidator.getClass().equals(validatorToRemoveClass)) continue;
            validatorToRemove = nextValidator;
        }
        if (validatorToRemove != null) {
            input.removeValidator(validatorToRemove);
        }
        if (addBeanValidator) {
            input.addValidator(beanValidator);
        }
    }

    private Validator createChildrenValidator(FacesContext context, UIComponent c) {
        AbstractGraphValidator graphValidator = (AbstractGraphValidator)c;
        return graphValidator.createChildrenValidator(context);
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        super.applyNextHandler(ctx, c);
        if (c.isInView()) {
            this.setupValidators(ctx.getFacesContext(), c, this.createChildrenValidator(ctx.getFacesContext(), c));
        } else {
            c.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)new FacesBeanValidatorAddListener());
        }
    }

    private class FacesBeanValidatorAddListener
    implements ComponentSystemEventListener,
    StateHolder {
        private FacesBeanValidatorAddListener() {
        }

        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            FacesContext context = FacesContext.getCurrentInstance();
            Validator childrenValidator = GraphValidatorHandler.this.createChildrenValidator(context, event.getComponent());
            GraphValidatorHandler.this.setupValidators(context, event.getComponent(), childrenValidator);
        }

        public Object saveState(FacesContext context) {
            throw new UnsupportedOperationException();
        }

        public void restoreState(FacesContext context, Object state) {
            throw new UnsupportedOperationException();
        }

        public boolean isTransient() {
            return true;
        }

        public void setTransient(boolean newTransientValue) {
            throw new UnsupportedOperationException();
        }
    }
}

