/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractInplaceSelect;
import org.richfaces.component.InplaceComponent;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.InplaceInputRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.SelectHelper;
import org.richfaces.renderkit.util.HtmlDimensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="inputBase.js"), @ResourceDependency(library="org.richfaces", name="inplaceBase.js"), @ResourceDependency(library="org.richfaces", name="popup.js"), @ResourceDependency(library="org.richfaces", name="popupList.js"), @ResourceDependency(library="org.richfaces", name="inplaceInput.js"), @ResourceDependency(library="org.richfaces", name="inplaceSelect.js"), @ResourceDependency(library="org.richfaces", name="inplaceSelect.ecss")})
public class InplaceSelectRendererBase
extends InplaceInputRendererBase {
    public static final String OPTIONS_OPEN_ON_EDIT = "openOnEdit";
    public static final String OPTIONS_SAVE_ON_SELECT = "saveOnSelect";
    public static final String ITEM_CSS = "rf-is-opt";
    public static final String SELECT_ITEM_CSS = "rf-is-sel";
    public static final String LIST_CSS = "rf-is-lst-cord";

    public List<ClientSelectItem> getConvertedSelectItems(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getConvertedSelectItems(facesContext, component);
    }

    public void encodeItems(FacesContext facesContext, UIComponent component, List<ClientSelectItem> clientSelectItems) throws IOException {
        SelectHelper.encodeItems(facesContext, component, clientSelectItems, "span", ITEM_CSS);
    }

    public void renderListHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, SelectHelper.SELECT_LIST_HANDLER_ATTRIBUTES);
    }

    @Override
    public void renderInputHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, INPLACE_INPUT_HANDLER_ATTRIBUTES);
    }

    public String getSelectInputLabel(FacesContext facesContext, UIComponent component) {
        return SelectHelper.getSelectInputLabel(facesContext, component);
    }

    public String getListWidth(UIComponent component) {
        AbstractInplaceSelect select = (AbstractInplaceSelect)component;
        String width = this.getListWidth(select);
        return width != null && width.trim().length() != 0 ? "width: " + width : "";
    }

    protected String getListWidth(AbstractInplaceSelect select) {
        String width = HtmlDimensions.formatSize((String)select.getListWidth());
        if (width == null || width.length() == 0) {
            width = "200px";
        }
        return width;
    }

    protected String getListHeight(AbstractInplaceSelect select) {
        String height = HtmlDimensions.formatSize((String)select.getListHeight());
        if (height == null || height.length() == 0) {
            height = "100px";
        }
        return height;
    }

    public String getListHeight(UIComponent component) {
        AbstractInplaceSelect select = (AbstractInplaceSelect)component;
        String height = this.getListHeight(select);
        return height != null && height.trim().length() != 0 ? "height: " + height : "";
    }

    public String getSelectLabel(FacesContext facesContext, UIComponent component) {
        AbstractInplaceSelect select = (AbstractInplaceSelect)component;
        String label = this.getSelectInputLabel(facesContext, (UIComponent)select);
        if (!select.isDisabled() && label == null) {
            label = select.getDefaultLabel();
        }
        return label;
    }

    @Override
    public String getReadyStateCss(InplaceComponent component) {
        String css = component.getReadyStateClass();
        return this.concatClasses("rf-is-d-s", css);
    }

    @Override
    public String getEditStateCss(InplaceComponent component) {
        String css = component.getEditStateClass();
        return this.concatClasses("rf-is-e-s", css);
    }

    @Override
    public String getChangedStateCss(InplaceComponent component) {
        String css = component.getChangedStateClass();
        return this.concatClasses("rf-is-c-s", css);
    }

    @Override
    public String getDisableStateCss(InplaceComponent component) {
        String css = component.getDisabledStateClass();
        return this.concatClasses("rf-is-dis-s", css);
    }

    @Override
    public String getEditCss(InplaceComponent component) {
        String css = component.getEditClass();
        return this.concatClasses("rf-is-edit", css);
    }

    @Override
    public String getNoneCss(InplaceComponent component) {
        String css = component.getNoneClass();
        return this.concatClasses("rf-is-none", css);
    }

    public String getListCss(UIComponent component) {
        AbstractInplaceSelect inplaceSelect = (AbstractInplaceSelect)component;
        String css = inplaceSelect.getListClass();
        css = css != null ? this.concatClasses(LIST_CSS, css) : LIST_CSS;
        return css;
    }

    protected String getInputWidthStyle(UIComponent component) {
        String value = ((AbstractInplaceSelect)component).getInputWidth();
        if (value == null || "".equals(value)) {
            return "";
        }
        return "width: " + HtmlDimensions.formatSize((String)value) + ";";
    }
}

