/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractMediaOutput;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.UserResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamicResource
public class MediaOutputResource
implements StateHolder,
UserResource,
CacheableResource {
    private String contentType;
    private boolean cacheable;
    private MethodExpression contentProducer;
    private ValueExpression expiresExpression;
    private ValueExpression lastModifiedExpression;
    private ValueExpression timeToLiveExpression;
    private Object userData;

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.contentProducer.invoke(facesContext.getELContext(), new Object[]{baos, this.userData});
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.isCacheable(context) ? Boolean.TRUE : Boolean.FALSE, this.getContentType(), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.userData), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.contentProducer)};
        return state;
    }

    public void restoreState(FacesContext context, Object stateObject) {
        Object[] state = (Object[])stateObject;
        this.setCacheable((Boolean)state[0]);
        this.setContentType((String)state[1]);
        this.userData = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[2]);
        this.contentProducer = (MethodExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[3]);
    }

    public void initialize(AbstractMediaOutput uiMediaOutput) {
        this.setCacheable(uiMediaOutput.isCacheable());
        this.setContentType(uiMediaOutput.getMimeType());
        this.userData = uiMediaOutput.getValue();
        this.contentProducer = uiMediaOutput.getCreateContentExpression();
        this.lastModifiedExpression = uiMediaOutput.getValueExpression("lastModfied");
        this.expiresExpression = uiMediaOutput.getValueExpression("expires");
        this.timeToLiveExpression = uiMediaOutput.getValueExpression("timeToLive");
    }

    public boolean isCacheable(FacesContext context) {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public Date getExpires(FacesContext context) {
        return null;
    }

    public int getTimeToLive(FacesContext context) {
        return -1;
    }

    public String getEntityTag(FacesContext context) {
        return null;
    }

    public Map<String, String> getResponseHeaders() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return -1;
    }
}

