/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import org.resteasy.util.MediaTypeHelper;
import org.resteasy.util.QualifiedStringHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptableVariant
implements Comparable<AcceptableVariant> {
    private Variant variant;
    private MediaType type;
    private QualifiedStringHeader language;
    private QualifiedStringHeader encoding;

    public AcceptableVariant(Variant variant) {
        this.variant = variant;
        this.type = variant.getMediaType();
        if (variant.getLanguage() != null) {
            this.language = QualifiedStringHeader.parse(variant.getLanguage());
        }
        if (variant.getEncoding() != null) {
            this.encoding = QualifiedStringHeader.parse(variant.getEncoding());
        }
    }

    @Override
    public int compareTo(AcceptableVariant acceptableVariant) {
        int compare = 0;
        if (this.type == acceptableVariant.type) {
            compare = 0;
        } else if (this.type != null && acceptableVariant.type != null) {
            compare = MediaTypeHelper.compareWeight(this.type, acceptableVariant.type);
        } else if (this.type == null) {
            compare = 1;
        } else if (this.type != null) {
            compare = -1;
        }
        if (compare != 0) {
            return compare;
        }
        if (this.language == acceptableVariant.language) {
            compare = 0;
        } else if (this.language != null && acceptableVariant.language != null) {
            compare = this.language.compareWeight(acceptableVariant.language);
        } else if (this.language == null) {
            compare = 1;
        } else if (this.language != null) {
            compare = -1;
        }
        if (compare != 0) {
            return compare;
        }
        if (this.encoding == acceptableVariant.encoding) {
            compare = 0;
        } else if (this.encoding != null && acceptableVariant.encoding != null) {
            compare = this.encoding.compareWeight(acceptableVariant.encoding);
        } else {
            if (this.encoding == null) {
                return 1;
            }
            if (this.encoding != null) {
                return -1;
            }
        }
        return 0;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public MediaType getType() {
        return this.type;
    }

    public QualifiedStringHeader getLanguage() {
        return this.language;
    }

    public QualifiedStringHeader getEncoding() {
        return this.encoding;
    }

    public static List<Variant> sort(List<Variant> variants) {
        ArrayList<AcceptableVariant> acceptable = new ArrayList<AcceptableVariant>();
        for (Variant v : variants) {
            acceptable.add(new AcceptableVariant(v));
        }
        Collections.sort(acceptable);
        ArrayList<Variant> sorted = new ArrayList<Variant>();
        for (AcceptableVariant v : acceptable) {
            sorted.add(v.getVariant());
        }
        return sorted;
    }

    public static Variant pick(List<Variant> wants, List<Variant> has) {
        ArrayList<AcceptableVariant> acceptable = new ArrayList<AcceptableVariant>();
        for (Variant v : wants) {
            acceptable.add(new AcceptableVariant(v));
        }
        Collections.sort(acceptable);
        ArrayList<AcceptableVariant> produces = new ArrayList<AcceptableVariant>();
        for (Variant v : has) {
            produces.add(new AcceptableVariant(v));
        }
        for (AcceptableVariant accept : acceptable) {
            for (AcceptableVariant produce : produces) {
                boolean match = false;
                match = produce.getType() == null || accept.getType() == null ? true : MediaTypeHelper.equivalent(produce.getType(), accept.getType());
                if (!match) continue;
                match = false;
                match = produce.getLanguage() == null || accept.getLanguage() == null ? true : produce.getLanguage().equals(accept.getLanguage());
                if (!match) continue;
                match = false;
                match = produce.getEncoding() == null || accept.getEncoding() == null ? true : produce.getEncoding().equals(accept.getEncoding());
                return produce.getVariant();
            }
        }
        return null;
    }
}

