/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.servlet;

import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.resteasy.spi.Registry;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.GetRestful;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SpringBeanProcessor
implements BeanPostProcessor {
    private Registry registry;
    private ResteasyProviderFactory factory;

    public SpringBeanProcessor(Registry registry, ResteasyProviderFactory factory) {
        this.registry = registry;
        this.factory = factory;
    }

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        if (GetRestful.isRootResource(bean.getClass())) {
            this.registry.addResourceFactory(new SingletonResource(bean));
        } else if (bean.getClass().isAnnotationPresent(Provider.class)) {
            if (bean instanceof MessageBodyReader) {
                this.factory.addMessageBodyReader((MessageBodyReader)bean);
            }
            if (bean instanceof MessageBodyWriter) {
                this.factory.addMessageBodyWriter((MessageBodyWriter)bean);
            }
        }
        return bean;
    }
}

