/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.lang.reflect.Method;
import java.util.Set;
import javax.ws.rs.Path;
import org.resteasy.Failure;
import org.resteasy.InjectorFactoryImpl;
import org.resteasy.PathParamIndex;
import org.resteasy.PathSegmentNode;
import org.resteasy.ResourceInvoker;
import org.resteasy.ResourceLocator;
import org.resteasy.ResourceMethod;
import org.resteasy.plugins.server.resourcefactory.JndiResourceFactory;
import org.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.Registry;
import org.resteasy.spi.ResourceFactory;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.GetRestful;
import org.resteasy.util.IsHttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMethodRegistry
implements Registry {
    protected int size;
    protected PathSegmentNode root = new PathSegmentNode();
    protected ResteasyProviderFactory providerFactory;

    public ResourceMethodRegistry(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    @Override
    public void addPerRequestResource(Class clazz, String basePath) {
        this.addResourceFactory(new POJOResourceFactory(clazz), basePath);
    }

    @Override
    public void addSingletonResource(Object singleton) {
        this.addResourceFactory(new SingletonResource(singleton));
    }

    @Override
    public void addSingletonResource(Object singleton, String basePath) {
        this.addResourceFactory(new SingletonResource(singleton), basePath);
    }

    @Override
    public void addJndiResource(String jndiName) {
        this.addResourceFactory(new JndiResourceFactory(jndiName));
    }

    @Override
    public void addJndiResource(String jndiName, String basePath) {
        this.addResourceFactory(new JndiResourceFactory(jndiName), basePath);
    }

    @Override
    public void addPerRequestResource(Class clazz) {
        this.addResourceFactory(new POJOResourceFactory(clazz));
    }

    @Override
    public void addResourceFactory(ResourceFactory ref) {
        this.addResourceFactory(ref, null);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base) {
        Class<?> clazz = ref.getScannableClass();
        Class restful = GetRestful.getRootResourceClass(clazz);
        if (restful == null) {
            String msg = "Class is not a root resource.  It, or one of its interfaces must be annotated with @Path: " + clazz.getName() + " implements: ";
            for (Class<?> intf : clazz.getInterfaces()) {
                msg = msg + " " + intf.getName();
            }
            throw new RuntimeException(msg);
        }
        this.addResourceFactory(ref, base, restful, 0, true);
    }

    public void addResourceFactory(ResourceFactory ref, String base, Class<?> clazz, int offset, boolean limited) {
        if (ref != null) {
            ref.registered(new InjectorFactoryImpl(null, this.providerFactory));
        }
        for (Method method : clazz.getMethods()) {
            String pathExpression;
            Path path = method.getAnnotation(Path.class);
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (path == null && httpMethods == null) continue;
            UriBuilderImpl builder = new UriBuilderImpl();
            builder.setPath(base);
            if (clazz.isAnnotationPresent(Path.class)) {
                builder.path(clazz);
                limited = clazz.getAnnotation(Path.class).limited();
            }
            if (path != null) {
                if (!limited) {
                    throw new RuntimeException("It is illegal to have @Path.limited() == false on your class then use a @Path on a method too");
                }
                builder.path(method);
                limited = path.limited();
            }
            if ((pathExpression = builder.getPath()) == null) {
                pathExpression = "";
            }
            PathParamIndex index = new PathParamIndex(pathExpression, offset, !limited);
            InjectorFactoryImpl injectorFactory = new InjectorFactoryImpl(index, this.providerFactory);
            if (pathExpression.startsWith("/")) {
                pathExpression = pathExpression.substring(1);
            }
            String[] paths = pathExpression.split("/");
            if (httpMethods == null) {
                ResourceLocator locator = new ResourceLocator(ref, injectorFactory, this.providerFactory, method, index, limited);
                this.root.addChild(paths, 0, locator);
            } else {
                ResourceMethod invoker = new ResourceMethod(clazz, method, injectorFactory, ref, this.providerFactory, httpMethods, index);
                this.root.addChild(paths, 0, invoker, !limited);
            }
            ++this.size;
        }
    }

    @Override
    public void removeRegistrations(Class clazz) {
        this.removeRegistrations(clazz, null);
    }

    @Override
    public void removeRegistrations(Class clazz, String base) {
        Class restful = GetRestful.getRootResourceClass(clazz);
        this.removeRegistration(base, restful);
    }

    private void removeRegistration(String base, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String pathExpression;
            Path path = method.getAnnotation(Path.class);
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (path == null && httpMethods == null) continue;
            UriBuilderImpl builder = new UriBuilderImpl();
            builder.setPath(base);
            if (clazz.isAnnotationPresent(Path.class)) {
                builder.path(clazz);
            }
            if (path != null) {
                builder.path(method);
            }
            if ((pathExpression = builder.getPath()) == null) {
                pathExpression = "";
            }
            if (pathExpression.startsWith("/")) {
                pathExpression = pathExpression.substring(1);
            }
            String[] paths = pathExpression.split("/");
            if (httpMethods == null) {
                if (this.root.removeLocator(paths, 0) == null) continue;
                --this.size;
                continue;
            }
            try {
                if (this.root.removeChild(paths, 0, method) == null) continue;
                --this.size;
            }
            catch (Exception e) {
                throw new RuntimeException("pathExpression: " + pathExpression, e);
            }
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public ResourceInvoker getResourceInvoker(HttpRequest request, HttpResponse response) {
        return this.root.findResourceInvoker(request, response, 0);
    }

    public ResourceInvoker getResourceInvoker(HttpRequest request, HttpResponse response, int pathIndex, boolean limited) {
        if (pathIndex >= request.getUri().getPathSegments().size() || !limited) {
            PathSegmentNode empty = this.root.getChild("");
            if (empty == null) {
                throw new Failure(404);
            }
            return empty.findResourceInvoker(request, response, pathIndex);
        }
        return this.root.findResourceInvoker(request, response, pathIndex);
    }
}

