/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.resteasy.Failure;
import org.resteasy.InjectorFactoryImpl;
import org.resteasy.MessageBodyParameterInjector;
import org.resteasy.PathParamIndex;
import org.resteasy.ValueInjector;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.PropertyInjector;
import org.resteasy.spi.ResteasyProviderFactory;

public class PropertyInjectorImpl
implements PropertyInjector {
    protected HashMap<Field, ValueInjector> fieldMap = new HashMap();
    protected List<SetterMethod> setters = new ArrayList<SetterMethod>();
    protected HashMap<Long, Method> setterhashes = new HashMap();
    protected Class clazz;

    public PropertyInjectorImpl(Class clazz, PathParamIndex index, ResteasyProviderFactory factory) {
        this.clazz = clazz;
        this.populateMap(clazz, index, factory);
    }

    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodDesc = new StringBuffer(method.getName() + "(");
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc.append(PropertyInjectorImpl.getTypeString(parameterTypes[j]));
        }
        methodDesc.append(")" + PropertyInjectorImpl.getTypeString(method.getReturnType()));
        return PropertyInjectorImpl.createHash(methodDesc.toString());
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + PropertyInjectorImpl.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    protected void populateMap(Class clazz, PathParamIndex index, ResteasyProviderFactory factory) {
        Type genericType;
        Class<?> type;
        ValueInjector extractor;
        Annotation[] annotations;
        for (Field field : clazz.getDeclaredFields()) {
            annotations = field.getAnnotations();
            if (annotations == null || annotations.length == 0 || (extractor = InjectorFactoryImpl.getParameterExtractor(index, type = field.getType(), genericType = field.getGenericType(), annotations, field, factory)) instanceof MessageBodyParameterInjector) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            this.fieldMap.put(field, extractor);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Method older;
            if (!((Method)accessibleObject).getName().startsWith("set") || ((Method)accessibleObject).getParameterTypes().length != 1 || (annotations = accessibleObject.getAnnotations()) == null || annotations.length == 0 || (extractor = InjectorFactoryImpl.getParameterExtractor(index, type = ((Method)accessibleObject).getParameterTypes()[0], genericType = ((Method)accessibleObject).getGenericParameterTypes()[0], annotations, accessibleObject, factory)) instanceof MessageBodyParameterInjector) continue;
            long hash = 0L;
            try {
                hash = PropertyInjectorImpl.methodHash((Method)accessibleObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Modifier.isPrivate(((Method)accessibleObject).getModifiers()) && (older = this.setterhashes.get(hash)) != null) continue;
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) {
                ((Method)accessibleObject).setAccessible(true);
            }
            this.setters.add(new SetterMethod((Method)accessibleObject, extractor));
            this.setterhashes.put(hash, (Method)accessibleObject);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            this.populateMap(clazz.getSuperclass(), index, factory);
        }
    }

    public void inject(HttpRequest request, HttpResponse response, Object target) throws Failure {
        for (Map.Entry<Field, ValueInjector> entry : this.fieldMap.entrySet()) {
            try {
                entry.getKey().set(target, entry.getValue().inject(request, response));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        for (SetterMethod setter : this.setters) {
            try {
                setter.method.invoke(target, setter.extractor.inject(request, response));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void inject(Object target) {
        for (Map.Entry<Field, ValueInjector> entry : this.fieldMap.entrySet()) {
            try {
                entry.getKey().set(target, entry.getValue().inject());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        for (SetterMethod setter : this.setters) {
            try {
                setter.method.invoke(target, setter.extractor.inject());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SetterMethod {
        public Method method;
        public ValueInjector extractor;

        private SetterMethod(Method method, ValueInjector extractor) {
            this.method = method;
            this.extractor = extractor;
        }
    }
}

