/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import org.resteasy.Failure;
import org.resteasy.InjectorFactoryImpl;
import org.resteasy.PathParamIndex;
import org.resteasy.ValueInjector;
import org.resteasy.spi.ConstructorInjector;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.ResteasyProviderFactory;

public class ConstructorInjectorImpl
implements ConstructorInjector {
    protected Constructor constructor;
    protected ValueInjector[] params;
    protected PathParamIndex index;

    public ConstructorInjectorImpl(Constructor constructor, PathParamIndex index, ResteasyProviderFactory factory) {
        this.constructor = constructor;
        this.index = index;
        this.params = new ValueInjector[constructor.getParameterTypes().length];
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> type = constructor.getParameterTypes()[i];
            Type genericType = constructor.getGenericParameterTypes()[i];
            Annotation[] annotations = constructor.getParameterAnnotations()[i];
            this.params[i] = InjectorFactoryImpl.getParameterExtractor(index, type, genericType, annotations, constructor, factory);
        }
    }

    public Object[] injectableArguments(HttpRequest input, HttpResponse response) {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject(input, response);
            }
        }
        return args;
    }

    public Object[] injectableArguments() {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject();
            }
        }
        return args;
    }

    public Object construct(HttpRequest request, HttpResponse httpResponse) throws Failure {
        Object[] args = null;
        try {
            args = this.injectableArguments(request, httpResponse);
        }
        catch (Exception e) {
            throw new Failure("Failed processing arguments of " + this.constructor.toString(), e, 400);
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e);
        }
        catch (InvocationTargetException e) {
            WebApplicationException wae;
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException && (wae = (WebApplicationException)cause).getResponse() != null) {
                cause.printStackTrace();
                return wae.getResponse();
            }
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.constructor.toString() + "  (";
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new RuntimeException(msg, e);
        }
    }

    public Object construct() {
        Object[] args = null;
        args = this.injectableArguments();
        try {
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.constructor.toString() + "  (";
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new RuntimeException(msg, e);
        }
    }
}

