/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.features.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.kernel.gshell.features.Feature;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed Feature", currencyTimeLimit=15)
public class FeatureImpl
implements Feature {
    private String id;
    private String name;
    private String version;
    private List<Feature> dependencies = new ArrayList<Feature>();
    private List<String> bundles = new ArrayList<String>();
    private Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
    public static String SPLIT_FOR_NAME_AND_VERSION = "_split_for_name_and_version_";
    public static String DEFAULT_VERSION = "0.0.0";

    public FeatureImpl(String name) {
        this(name, DEFAULT_VERSION);
    }

    public FeatureImpl(String name, String version) {
        this.name = name;
        this.version = version;
        this.id = name + "-" + version;
    }

    @Override
    @ManagedAttribute(description="Feature Unique ID")
    public String getId() {
        return this.id;
    }

    @Override
    @ManagedAttribute(description="Feature Name")
    public String getName() {
        return this.name;
    }

    @Override
    @ManagedAttribute(description="Feature Version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    @ManagedAttribute(description="List of Dependencies")
    public List<Feature> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<String> getBundles() {
        return this.bundles;
    }

    @Override
    public Map<String, Map<String, String>> getConfigurations() {
        return this.configs;
    }

    public void addDependency(Feature dependency) {
        this.dependencies.add(dependency);
    }

    public void addBundle(String bundle) {
        this.bundles.add(bundle);
    }

    public void addConfig(String name, Map<String, String> properties) {
        this.configs.put(name, properties);
    }

    public String toString() {
        String ret = this.getName() + SPLIT_FOR_NAME_AND_VERSION + this.getVersion();
        return ret;
    }

    public static Feature valueOf(String str) {
        if (str.indexOf(SPLIT_FOR_NAME_AND_VERSION) >= 0) {
            String strName = str.substring(0, str.indexOf(SPLIT_FOR_NAME_AND_VERSION));
            String strVersion = str.substring(str.indexOf(SPLIT_FOR_NAME_AND_VERSION) + SPLIT_FOR_NAME_AND_VERSION.length(), str.length());
            return new FeatureImpl(strName, strVersion);
        }
        return new FeatureImpl(str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureImpl feature = (FeatureImpl)o;
        if (!this.name.equals(feature.name)) {
            return false;
        }
        return this.version.equals(feature.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

