/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.ldap;

import java.util.Stack;
import org.apache.felix.framework.util.ldap.AttributeNotFoundException;
import org.apache.felix.framework.util.ldap.EvaluationException;
import org.apache.felix.framework.util.ldap.Mapper;
import org.apache.felix.framework.util.ldap.Operator;
import org.apache.felix.framework.util.ldap.Unknown;

public class Evaluator {
    Object[] program = null;
    Stack operands = new Stack();
    Mapper mapper = null;
    static /* synthetic */ Class class$org$apache$felix$framework$util$ldap$Unknown;

    public Evaluator() {
        this.reset();
    }

    public Evaluator(Object[] prog) {
        this.reset(prog);
    }

    public void reset() {
        this.program = null;
        this.mapper = null;
        this.operands.clear();
    }

    public void reset(Object[] prog) {
        this.reset();
        this.setProgram(prog);
    }

    public void setProgram(Object[] prog) {
        this.program = prog;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Stack getOperands() {
        return this.operands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(Mapper mapper) throws EvaluationException {
        try {
            this.setMapper(mapper);
            for (int i = 0; i < this.program.length; ++i) {
                try {
                    Operator op = (Operator)this.program[i];
                    op.execute(this.operands, mapper);
                    continue;
                }
                catch (AttributeNotFoundException ex) {
                    this.operands.push(new Unknown());
                    continue;
                }
                catch (EvaluationException ex) {
                    if (ex.isUnsupportedType() && ex.getUnsupportedType() == (class$org$apache$felix$framework$util$ldap$Unknown == null ? Evaluator.class$("org.apache.felix.framework.util.ldap.Unknown") : class$org$apache$felix$framework$util$ldap$Unknown)) {
                        this.operands.push(Boolean.FALSE);
                        continue;
                    }
                    throw ex;
                }
            }
            if (this.operands.empty()) {
                throw new EvaluationException("Evaluation.evalute: final stack is empty");
            }
            Object result = this.operands.pop();
            if (!this.operands.empty()) {
                throw new EvaluationException("Evaluation.evalute: final stack has more than one result");
            }
            if (!(result instanceof Boolean)) {
                throw new EvaluationException("Evaluation.evalute: final result is not Boolean");
            }
            boolean bl = (Boolean)result;
            return bl;
        }
        finally {
            this.operands.clear();
        }
    }

    void printAction(Operator op) {
        System.err.println("Operator:" + op.toString());
        System.err.print("Stack After:");
        Stack v = this.operands;
        int len = v.size();
        for (int i = 0; i < len; ++i) {
            System.err.print(" " + v.elementAt(i));
        }
        System.err.println();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.program.length; ++i) {
            buf.append(i == 0 ? "{" : ";");
            buf.append(((Operator)this.program[i]).toString());
        }
        buf.append("}");
        return buf.toString();
    }

    public String toStringInfix() {
        this.operands.clear();
        for (int i = 0; i < this.program.length; ++i) {
            ((Operator)this.program[i]).buildTree(this.operands);
        }
        StringBuffer b = new StringBuffer();
        Object result = this.operands.pop();
        ((Operator)result).toStringInfix(b);
        this.operands.clear();
        return b.toString();
    }
}

