/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class InsertDependencyComparator
implements Comparator<Content> {
    private final Map<Content, Float> positions = new LinkedHashMap<Content, Float>();
    private static final Comparator<Xml.Tag> dependencyComparator = (d1, d2) -> {
        String artifactId2;
        String groupId2;
        Scope scope2;
        Scope scope1 = Scope.fromName(d1.getChildValue("scope").orElse(null));
        if (scope1 != (scope2 = Scope.fromName(d2.getChildValue("scope").orElse(null)))) {
            return scope1.compareTo(scope2);
        }
        String groupId1 = d1.getChildValue("groupId").orElse("");
        if (!groupId1.equals(groupId2 = d2.getChildValue("groupId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(groupId1, groupId2);
        }
        String artifactId1 = d1.getChildValue("artifactId").orElse("");
        if (!artifactId1.equals(artifactId2 = d2.getChildValue("artifactId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(artifactId1, artifactId2);
        }
        String classifier1 = d1.getChildValue("classifier").orElse(null);
        String classifier2 = d2.getChildValue("classifier").orElse(null);
        if (classifier1 == null && classifier2 != null) {
            return -1;
        }
        if (classifier1 != null) {
            if (classifier2 == null) {
                return 1;
            }
            if (!classifier1.equals(classifier2)) {
                return classifier1.compareTo(classifier2);
            }
        }
        return d1.getChildValue("version").orElse("").compareTo(d2.getChildValue("version").orElse(""));
    };

    /*
     * WARNING - void declaration
     */
    public InsertDependencyComparator(List<? extends Content> existingDependencies, Xml.Tag dependencyTag) {
        void var7_13;
        LinkedHashMap dependencyWithPrecedingComments = new LinkedHashMap();
        ArrayList<Object> currentComments = new ArrayList<Object>();
        for (int i = 0; i < existingDependencies.size(); ++i) {
            Content content = existingDependencies.get(i);
            if (content instanceof Xml.Tag) {
                dependencyWithPrecedingComments.put((Xml.Tag)content, new ArrayList(currentComments));
                currentComments.clear();
                continue;
            }
            currentComments.add(content);
        }
        float position = 0.0f;
        for (Map.Entry entry : dependencyWithPrecedingComments.entrySet()) {
            for (Content comment : (List)entry.getValue()) {
                this.positions.put(comment, Float.valueOf(position));
                position += 0.1f;
            }
            this.positions.put((Content)entry.getKey(), Float.valueOf(position));
            position += 1.0f;
        }
        for (Content content : currentComments) {
            this.positions.put(content, Float.valueOf(position));
            position += 0.1f;
        }
        ArrayList dependencies = new ArrayList(dependencyWithPrecedingComments.keySet());
        if (dependencies.isEmpty()) {
            this.positions.put((Content)dependencyTag, Float.valueOf(position));
            return;
        }
        dependencies.add(dependencyTag);
        dependencies.sort(dependencyComparator);
        Object var7_11 = null;
        for (int i = 0; i < dependencies.size(); ++i) {
            Xml.Tag d = (Xml.Tag)dependencies.get(i);
            if (dependencyTag != d) continue;
            if (i <= 0) break;
            Xml.Tag tag = (Xml.Tag)dependencies.get(i - 1);
            break;
        }
        if (var7_13 == null) {
            this.positions.put((Content)dependencyTag, Float.valueOf(-0.5f));
        } else {
            this.positions.put((Content)dependencyTag, Float.valueOf(this.positions.get(var7_13).floatValue() + 0.5f));
        }
    }

    @Override
    public int compare(Content o1, Content o2) {
        return this.positions.get(o1).compareTo(this.positions.get(o2));
    }

    private static int comparePartByPart(String d1, String d2) {
        String[] d1Parts = d1.split("[.-]");
        String[] d2Parts = d2.split("[.-]");
        for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
            if (d1Parts[i].equals(d2Parts[i])) continue;
            return d1Parts[i].compareTo(d2Parts[i]);
        }
        return d1Parts.length - d2Parts.length;
    }
}

