/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.sizes;

import java.util.ArrayDeque;
import java.util.Deque;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@FileStatefulCheck
public final class ExecutableStatementCountCheck
extends AbstractCheck {
    public static final String MSG_KEY = "executableStatementCount";
    private static final int DEFAULT_MAX = 30;
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private int max = 30;
    private Context context;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 11, 12, 7, 203, 181};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{7};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 11, 12, 7, 203, 181};
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.context = new Context(null);
        this.contextStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ExecutableStatementCountCheck.isContainerNode(ast)) {
            this.visitContainerNode(ast);
        } else if (TokenUtil.isOfType(ast, 7)) {
            this.visitSlist(ast);
        } else {
            throw new IllegalStateException(ast.toString());
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ExecutableStatementCountCheck.isContainerNode(ast)) {
            this.leaveContainerNode(ast);
        } else if (!TokenUtil.isOfType(ast, 7)) {
            throw new IllegalStateException(ast.toString());
        }
    }

    private void visitContainerNode(DetailAST ast) {
        this.contextStack.push(this.context);
        this.context = new Context(ast);
    }

    private void leaveContainerNode(DetailAST ast) {
        int count = this.context.getCount();
        if (count > this.max) {
            this.log(ast, MSG_KEY, count, this.max);
        }
        this.context = this.contextStack.pop();
    }

    private void visitSlist(DetailAST ast) {
        DetailAST parent;
        DetailAST contextAST = this.context.getAST();
        for (parent = ast.getParent(); parent != null && !ExecutableStatementCountCheck.isContainerNode(parent); parent = parent.getParent()) {
        }
        if (parent == contextAST) {
            this.context.addCount(ast.getChildCount() / 2);
        }
    }

    private static boolean isContainerNode(DetailAST node) {
        return TokenUtil.isOfType(node, 9, 181, 8, 11, 12, 203);
    }

    private static class Context {
        private final DetailAST ast;
        private int count;

        Context(DetailAST ast) {
            this.ast = ast;
            this.count = 0;
        }

        public void addCount(int addition) {
            this.count += addition;
        }

        public DetailAST getAST() {
            return this.ast;
        }

        public int getCount() {
            return this.count;
        }
    }
}

