/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitAssertArrayEqualsToAssertThat
extends Recipe {
    private static final String JUNIT = "org.junit.jupiter.api.Assertions";
    private static final String ASSERTJ = "org.assertj.core.api.Assertions";
    private static final MethodMatcher ASSERT_ARRAY_EQUALS_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertArrayEquals(..)", true);

    public String getDisplayName() {
        return "JUnit `assertArrayEquals` to assertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertArrayEquals()` to AssertJ's `assertThat().contains()` equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_ARRAY_EQUALS_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation md = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_ARRAY_EQUALS_MATCHER.matches((MethodCall)md)) {
                    return md;
                }
                this.maybeAddImport(JUnitAssertArrayEqualsToAssertThat.ASSERTJ, "assertThat", false);
                this.maybeRemoveImport(JUnitAssertArrayEqualsToAssertThat.JUNIT);
                List args = md.getArguments();
                Expression expected = (Expression)args.get(0);
                Expression actual = (Expression)args.get(1);
                if (args.size() == 2) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{anyArray()}).containsExactly(#{anyArray()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.getCursor(), md.getCoordinates().replace(), new Object[]{actual, expected});
                }
                if (args.size() == 3 && this.isFloatingPointType((Expression)args.get(2))) {
                    this.maybeAddImport(JUnitAssertArrayEqualsToAssertThat.ASSERTJ, "within", false);
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{anyArray()}).containsExactly(#{anyArray()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.getCursor(), md.getCoordinates().replace(), new Object[]{actual, expected, args.get(2)});
                }
                if (args.size() == 3) {
                    Expression message = (Expression)args.get(2);
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{anyArray()}).as(#{any()}).containsExactly(#{anyArray()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.getCursor(), md.getCoordinates().replace(), new Object[]{actual, message, expected});
                }
                this.maybeAddImport(JUnitAssertArrayEqualsToAssertThat.ASSERTJ, "within", false);
                Expression message = (Expression)args.get(3);
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{anyArray()}).as(#{any()}).containsExactly(#{anyArray()}, within(#{}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.getCursor(), md.getCoordinates().replace(), new Object[]{actual, message, expected, args.get(2)});
            }

            private boolean isFloatingPointType(Expression expression) {
                JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)expression.getType());
                if (fullyQualified != null) {
                    String typeName = fullyQualified.getFullyQualifiedName();
                    return "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName);
                }
                JavaType.Primitive parameterType = TypeUtils.asPrimitive((JavaType)expression.getType());
                return parameterType == JavaType.Primitive.Double || parameterType == JavaType.Primitive.Float;
            }
        });
    }
}

