/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class OnlyCatchDeclaredExceptions
extends Recipe {
    private static final String JAVA_LANG_EXCEPTION = "java.lang.Exception";

    public String getDisplayName() {
        return "Replace `catch(Exception)` with specific declared exceptions thrown in the try block";
    }

    public String getDescription() {
        return "Replaces `catch(Exception e)` blocks with a multi-catch block (`catch (SpecificException1 | SpecificException2 e)`) containing only the exceptions declared thrown by method or constructor invocations within the `try` block that are not already caught by more specific `catch` clauses.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("CWE-396", "RSPEC-S2221"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.Try visitTry(J.Try aTry, ExecutionContext ctx) {
                J.Try t = super.visitTry(aTry, (Object)ctx);
                return t.withCatches(ListUtils.map((List)t.getCatches(), c -> {
                    if (this.isGenericCatch((J.Try.Catch)c)) {
                        Set<JavaType> declaredThrown = this.getDeclaredThrownExceptions(t);
                        declaredThrown.removeAll(this.getCaughtExceptions(t));
                        if (!declaredThrown.isEmpty() && !this.containsGenericTypeVariable(declaredThrown)) {
                            return this.multiCatchWithDeclaredExceptions((J.Try.Catch)c, declaredThrown);
                        }
                    }
                    return c;
                }));
            }

            private boolean isGenericCatch(J.Try.Catch aCatch) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)aCatch.getParameter().getType());
                if (fq != null) {
                    String fqn = fq.getFullyQualifiedName();
                    return TypeUtils.fullyQualifiedNamesAreEqual((String)OnlyCatchDeclaredExceptions.JAVA_LANG_EXCEPTION, (String)fqn);
                }
                return false;
            }

            private boolean containsGenericTypeVariable(Set<JavaType> types) {
                for (JavaType type : types) {
                    if (!(type instanceof JavaType.GenericTypeVariable)) continue;
                    return true;
                }
                return false;
            }

            private Set<JavaType> getCaughtExceptions(J.Try aTry) {
                HashSet<JavaType> caughtExceptions = new HashSet<JavaType>();
                for (J.Try.Catch c : aTry.getCatches()) {
                    JavaType type = c.getParameter().getType();
                    if (type instanceof JavaType.MultiCatch) {
                        caughtExceptions.addAll(((JavaType.MultiCatch)type).getThrowableTypes());
                        continue;
                    }
                    if (type == null) continue;
                    caughtExceptions.add(type);
                }
                return caughtExceptions;
            }

            private Set<JavaType> getDeclaredThrownExceptions(J.Try aTry) {
                return (Set)new JavaIsoVisitor<Set<JavaType>>(){

                    public @Nullable JavaType visitType(@Nullable JavaType javaType, Set<JavaType> javaTypes) {
                        if (javaType instanceof JavaType.Method) {
                            javaTypes.addAll(((JavaType.Method)javaType).getThrownExceptions());
                        }
                        return super.visitType(javaType, javaTypes);
                    }
                }.reduce((Tree)aTry.getBody(), new HashSet());
            }

            private J.Try.Catch multiCatchWithDeclaredExceptions(J.Try.Catch aCatch, Set<JavaType> thrownExceptions) {
                String[] imports;
                List fqs = thrownExceptions.stream().map(TypeUtils::asFullyQualified).filter(Objects::nonNull).sorted(Comparator.comparing(JavaType.FullyQualified::getClassName)).collect(Collectors.toList());
                String throwableTypes = fqs.stream().map(JavaType.FullyQualified::getClassName).collect(Collectors.joining("|"));
                for (String s : imports = (String[])fqs.stream().map(JavaType.FullyQualified::getFullyQualifiedName).toArray(String[]::new)) {
                    this.maybeAddImport(s, false);
                }
                J.Try surroundingTry = (J.Try)this.getCursor().firstEnclosing(J.Try.class);
                assert (surroundingTry != null);
                String variableName = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)aCatch.getParameter().getTree()).getVariables().get(0)).getSimpleName();
                J.Try generatedTry = (J.Try)JavaTemplate.builder((String)String.format("try {} catch (%s %s) {}", throwableTypes, variableName)).imports(imports).build().apply(new Cursor(this.getCursor(), (Object)surroundingTry), surroundingTry.getCoordinates().replace(), new Object[0]);
                return aCatch.withParameter(((J.Try.Catch)generatedTry.getCatches().get(0)).getParameter());
            }
        };
        return Preconditions.check((TreeVisitor)new UsesType(JAVA_LANG_EXCEPTION, Boolean.valueOf(false)), (TreeVisitor)visitor);
    }
}

