/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codehaus.plexus;

import java.io.File;
import org.codehaus.plexus.util.FileUtils;
import org.openrewrite.java.template.RecipeDescriptor;

class PlexusFileUtils {
    PlexusFileUtils() {
    }

    @RecipeDescriptor(name="Replace `FileUtils.getFile(String)` with JDK provided API", description="Replace Plexus `FileUtils.getFile(String fileName)` with JDK provided API.")
    static class GetFile {
        GetFile() {
        }

        File before(String fileName) {
            return FileUtils.getFile((String)fileName);
        }

        File after(String fileName) {
            return new File(fileName);
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.fileExists(String)` with JDK provided API", description="Replace Plexus `FileUtils.fileExists(String fileName)` with JDK provided API.")
    static class FileExistsString {
        FileExistsString() {
        }

        boolean before(String fileName) {
            return FileUtils.fileExists((String)fileName);
        }

        boolean after(String fileName) {
            return new File(fileName).exists();
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.deleteDirectory(String)` with JDK provided API", description="Replace Plexus `FileUtils.deleteDirectory(String directory)` with JDK provided API.")
    static class DeleteDirectoryString {
        DeleteDirectoryString() {
        }

        void before(String dir) throws Exception {
            FileUtils.deleteDirectory((String)dir);
        }

        void after(String dir) throws Exception {
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(dir));
        }
    }

    @RecipeDescriptor(name="Replace `FileUtils.deleteDirectory(File)` with JDK provided API", description="Replace Plexus `FileUtils.deleteDirectory(File directory)` with JDK provided API.")
    static class DeleteDirectoryFile {
        DeleteDirectoryFile() {
        }

        void before(File dir) throws Exception {
            FileUtils.deleteDirectory((File)dir);
        }

        void after(File dir) throws Exception {
            org.apache.commons.io.FileUtils.deleteDirectory((File)dir);
        }
    }
}

