/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class XPathFunctionCall
extends FunctionCall {
    private XPathFunction function;

    public XPathFunctionCall(XPathFunction function) {
        this.function = function;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ValueRepresentation[] argValues = new ValueRepresentation[this.argument.length];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = ExpressionTool.lazyEvaluate(this.argument[i], context, 10);
        }
        return this.call(argValues, context);
    }

    public SequenceIterator call(ValueRepresentation[] argValues, XPathContext context) throws XPathException {
        ArrayList<Object> convertedArgs = new ArrayList<Object>(argValues.length);
        for (int i = 0; i < argValues.length; ++i) {
            convertedArgs.add(Value.asValue(argValues[i]).convertToJava(Object.class, context));
        }
        try {
            Object result = this.function.evaluate(convertedArgs);
            Configuration config = context.getConfiguration();
            return Value.convertJavaObjectToXPath(result, SequenceType.ANY_SEQUENCE, context).iterate();
        }
        catch (XPathFunctionException e) {
            throw new XPathException(e);
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }
}

