/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaPekkoClientCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    protected String mainPackage = "org.openapitools.client";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-client";
    protected String artifactVersion = "1.0.0";
    protected String resourcesFolder = "src/main/resources";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String configKey = "apiRequest";
    protected int defaultTimeoutInMs = 5000;
    protected String configKeyPath = this.mainPackage;
    protected boolean registerNonStandardStatusCodes = true;
    protected boolean renderJavadoc = true;
    protected boolean removeOAuthSecurities = true;
    protected final Logger LOGGER = LoggerFactory.getLogger(ScalaPekkoClientCodegen.class);

    public ScalaPekkoClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.outputFolder = "generated-code/scala-pekko";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.templateDir = "scala-pekko-client";
        this.embeddedTemplateDir = "scala-pekko-client";
        this.apiPackage = this.mainPackage + ".api";
        this.modelPackage = this.mainPackage + ".model";
        this.invokerPackage = this.mainPackage + ".core";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("configKey", this.configKey);
        this.additionalProperties.put("configKeyPath", this.configKeyPath);
        this.additionalProperties.put("defaultTimeout", this.defaultTimeoutInMs);
        if (this.renderJavadoc) {
            this.additionalProperties.put("javadocRenderer", new JavadocLambda());
        }
        this.additionalProperties.put("fnCapitalize", new CapitalizeLambda());
        this.additionalProperties.put("fnCamelize", new AbstractScalaCodegen.CamelizeLambda(false));
        this.additionalProperties.put("fnEnumEntry", new EnumEntryLambda());
        this.importMapping.remove("Seq");
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("decimal", "BigDecimal");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "Map");
        this.cliOptions.add(new CliOption("mainPackage", "Top-level package name, which defines 'apiPackage', 'modelPackage', 'invokerPackage'").defaultValue("org.openapitools.client"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        }
        if (this.additionalProperties.containsKey("mainPackage")) {
            this.setMainPackage((String)this.additionalProperties.get("mainPackage"));
            this.additionalProperties.replace("configKeyPath", this.configKeyPath);
            if (!this.additionalProperties.containsKey("apiPackage")) {
                this.apiPackage = this.mainPackage + ".api";
                this.additionalProperties.put("apiPackage", this.apiPackage);
            }
            if (!this.additionalProperties.containsKey("modelPackage")) {
                this.modelPackage = this.mainPackage + ".model";
                this.additionalProperties.put("modelPackage", this.modelPackage);
            }
            if (!this.additionalProperties.containsKey("invokerPackage")) {
                this.invokerPackage = this.mainPackage + ".core";
            }
        }
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("reference.mustache", this.resourcesFolder, "reference.conf"));
        String invokerFolder = (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("apiRequest.mustache", invokerFolder, "ApiRequest.scala"));
        this.supportingFiles.add(new SupportingFile("apiInvoker.mustache", invokerFolder, "ApiInvoker.scala"));
        this.supportingFiles.add(new SupportingFile("requests.mustache", invokerFolder, "requests.scala"));
        this.supportingFiles.add(new SupportingFile("apiSettings.mustache", invokerFolder, "ApiSettings.scala"));
        String apiFolder = (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("project/build.properties.mustache", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("enumsSerializers.mustache", apiFolder, "EnumsSerializers.scala"));
        this.supportingFiles.add(new SupportingFile("serializers.mustache", invokerFolder, "Serializers.scala"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "scala-pekko";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala client library (beta) base on pekko/Spray.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "`" + name + "`";
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        if (this.registerNonStandardStatusCodes) {
            try {
                OperationMap opsMap = objs.getOperations();
                HashSet<Integer> unknownCodes = new HashSet<Integer>();
                for (CodegenOperation operation : opsMap.getOperation()) {
                    for (CodegenResponse response : operation.responses) {
                        if ("default".equals(response.code)) continue;
                        try {
                            int code = Integer.parseInt(response.code);
                            if (code < 600) continue;
                            unknownCodes.add(code);
                        }
                        catch (NumberFormatException e) {
                            this.LOGGER.error("Status code is not an integer : response.code", (Throwable)e);
                        }
                    }
                }
                if (!unknownCodes.isEmpty()) {
                    this.additionalProperties.put("unknownStatusCodes", unknownCodes);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Unable to find operations List", (Throwable)e);
            }
        }
        return super.postProcessOperationsWithModels(objs, allModels);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> schemes) {
        List<CodegenSecurity> codegenSecurities = super.fromSecurity(schemes);
        if (!this.removeOAuthSecurities) {
            return codegenSecurities;
        }
        codegenSecurities.removeIf(security -> security.isOAuth);
        if (codegenSecurities.isEmpty()) {
            return null;
        }
        return codegenSecurities;
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        return this.formatIdentifier(name, false);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.formatIdentifier(property.baseName, true);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getRequired() != null && p.getRequired().contains(p.getName())) {
            return "None";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return null;
        }
        if (ModelUtils.isNumberSchema(p)) {
            return null;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return null;
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getAdditionalProperties(p));
            return "Map[String, " + inner + "].empty ";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            if (ModelUtils.isSet((Schema)ap)) {
                return "Set[" + inner + "].empty ";
            }
            return "Seq[" + inner + "].empty ";
        }
        if (ModelUtils.isStringSchema(p)) {
            return null;
        }
        return null;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    public void setMainPackage(String mainPackage) {
        this.configKeyPath = this.mainPackage = mainPackage;
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + File.separator + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + File.separator + this.modelDocPath).replace('/', File.separatorChar);
    }

    private class EnumEntryLambda
    extends AbstractScalaCodegen.CustomLambda {
        private EnumEntryLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return ScalaPekkoClientCodegen.this.formatIdentifier(fragment, true);
        }
    }

    private static class CapitalizeLambda
    extends AbstractScalaCodegen.CustomLambda {
        private CapitalizeLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return StringUtils.capitalize((String)fragment);
        }
    }

    private static class JavadocLambda
    extends AbstractScalaCodegen.CustomLambda {
        private JavadocLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            String[] lines = fragment.split("\\r?\\n");
            StringBuilder sb = new StringBuilder();
            sb.append("  /**\n");
            for (String line : lines) {
                sb.append("   * ").append(line).append("\n");
            }
            sb.append("   */\n");
            return sb.toString();
        }
    }
}

