/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import mondrian.xmla.Enumeration;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;
import mondrian.xmla.impl.JsonSaxWriter;
import org.olap4j.xmla.server.impl.Util;

public class DefaultXmlaResponse
implements XmlaResponse {
    private static final String MSG_ENCODING_ERROR = "Encoding unsupported: ";
    private final SaxWriter writer;

    public DefaultXmlaResponse(OutputStream outputStream, String encoding, Enumeration.ResponseMimeType responseMimeType) {
        try {
            switch (responseMimeType) {
                case JSON: {
                    this.writer = new JsonSaxWriter(outputStream);
                    break;
                }
                default: {
                    this.writer = new DefaultSaxWriter(outputStream, encoding);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw Util.newError(uee, MSG_ENCODING_ERROR + encoding);
        }
    }

    public SaxWriter getWriter() {
        return this.writer;
    }

    public void error(Throwable t) {
        this.writer.completeBeforeElement("root");
        Throwable throwable = XmlaUtil.rootThrowable(t);
        this.writer.startElement("Messages");
        this.writer.startElement("Error", "ErrorCode", throwable.getClass().getName(), "Description", throwable.getMessage(), "Source", "Mondrian", "Help", "");
        this.writer.endElement();
        this.writer.endElement();
    }
}

