/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.perftest;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.perftest.PerfTestLabelAdd;
import org.nuiton.wikitty.perftest.PerfTestLabelSearch;
import org.nuiton.wikitty.perftest.PerfTestSearch;
import org.nuiton.wikitty.perftest.PerfTestUtils;

public class PerfTest {
    private static Log log = LogFactory.getLog(PerfTest.class);

    public static void main(String[] args) {
        ApplicationConfig config = WikittyConfig.getConfig((String[])args);
        int threadsNb = 20;
        int researches = 2001;
        int loopsToAvg = 5;
        int wikittiesToCreate = 70;
        if (threadsNb > researches) {
            threadsNb = researches;
        }
        boolean skipSearchesTests = false;
        boolean skipLabelsTests = false;
        WikittyService ws = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        WikittyProxy proxy = new WikittyProxy(ws);
        WikittyExtension ext = ExtensionFactory.create((String)"perfTest", (String)"1").addField("name", FieldType.TYPE.STRING).addField("surname", FieldType.TYPE.STRING).addField("age", FieldType.TYPE.NUMERIC).addField("height", FieldType.TYPE.NUMERIC).addField("birth", FieldType.TYPE.DATE).addField("wedding", FieldType.TYPE.DATE).addField("isTrue", FieldType.TYPE.BOOLEAN).addField("isFalse", FieldType.TYPE.BOOLEAN).addField("wiki1", FieldType.TYPE.WIKITTY).addField("wiki2", FieldType.TYPE.WIKITTY).extension();
        Random rand = new Random();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < wikittiesToCreate; ++i) {
            WikittyImpl w = new WikittyImpl();
            ids.add(w.getId());
            w.addExtension(ext);
            w.setField(ext.getName(), "name", (Object)RandomStringUtils.randomAscii((int)15));
            w.setField(ext.getName(), "surname", (Object)RandomStringUtils.randomAscii((int)20));
            w.setField(ext.getName(), "age", (Object)rand.nextInt(110));
            w.setField(ext.getName(), "height", (Object)rand.nextInt(230));
            w.setField(ext.getName(), "isTrue", (Object)(rand.nextInt(1) == 0 ? 1 : 0));
            w.setField(ext.getName(), "isFalse", (Object)(rand.nextInt(1) == 1 ? 1 : 0));
            w.setField(ext.getName(), "birth", (Object)("01/01/" + rand.nextInt(2010)));
            w.setField(ext.getName(), "wiki1", (Object)w);
            proxy.store((Wikitty)w);
        }
        PerfTestUtils.out("Tests on searches :");
        if (!skipSearchesTests) {
            PerfTestUtils.out("== Tests on fields of type STRING ==");
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "name", "toto", true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "name", "toto", false);
            PerfTestUtils.out("------------\n");
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "surname", "a", true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "surname", "a", false);
            PerfTestUtils.out("== Tests on fields of type NUMERIC ==");
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "age", "40", true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "age", "40", false);
            PerfTestUtils.out("------------\n");
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "height", "100", true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "height", "100", false);
            PerfTestUtils.out("== Tests on a field of type BOOLEAN ==");
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "isTrue", "true", true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "isTrue", "true", false);
            PerfTestUtils.out("== Tests on a field of type DATE ==");
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "birth", "06/07/1720", true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "birth", "06/07/1720", false);
            PerfTestUtils.out("== Tests on a field of type WIKITTY ==");
            String wikittySearched = proxy.restore((String)ids.get(rand.nextInt(wikittiesToCreate))).toString();
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "wiki1", wikittySearched, true);
            PerfTestSearch.search(ws, ext, loopsToAvg, researches, wikittiesToCreate, threadsNb, "wiki1", wikittySearched, false);
        } else {
            PerfTestUtils.out("Skipped");
        }
        PerfTestUtils.out("Tests on labels :");
        if (!skipLabelsTests) {
            PerfTestLabelAdd.addLabel(proxy, ids, loopsToAvg, threadsNb);
            PerfTestLabelSearch.searchLabel(proxy, ids, loopsToAvg, threadsNb);
        } else {
            PerfTestUtils.out("Skipped");
        }
    }
}

