/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityIdsMap;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.TopiaReplicationOperationProvider;
import org.nuiton.topia.replication.TopiaReplicationOperationUndoable;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;

public class TopiaReplicationContext {
    private static final Log log = LogFactory.getLog(TopiaReplicationContext.class);
    protected final ReplicationModel replicationModel;
    protected final TopiaApplicationContext sourceTx;
    protected final TopiaApplicationContext targetTx;
    protected TopiaEntityIdsMap data;
    protected List<ReplicationNode> treated;
    protected TopiaReplicationOperationProvider operationProvider;

    public TopiaReplicationContext(TopiaReplicationOperationProvider operationProvider, ReplicationModel replicationModel, TopiaApplicationContext sourceTx, TopiaApplicationContext targetTx) {
        this.operationProvider = operationProvider;
        this.replicationModel = replicationModel;
        this.sourceTx = sourceTx;
        this.targetTx = targetTx;
    }

    public TopiaReplicationOperation getOperation(ReplicationOperationDef operationDef) {
        TopiaReplicationOperation operation = this.operationProvider.getOperation(operationDef);
        return operation;
    }

    public TopiaReplicationOperationUndoable getUndoableOperation(ReplicationOperationDef operationDef) throws IllegalArgumentException {
        TopiaReplicationOperationUndoable operation = this.operationProvider.getUndoableOperation(operationDef);
        return operation;
    }

    public ReplicationModel getReplicationModel() {
        return this.replicationModel;
    }

    public void addTreatedNode(ReplicationNode node) {
        this.getTreated().add(node);
    }

    public ReplicationNode[] getReverseTreated() {
        ArrayList<ReplicationNode> result = new ArrayList<ReplicationNode>(this.getTreated());
        Collections.reverse(result);
        return result.toArray(new ReplicationNode[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws TopiaException {
        TopiaPersistenceContext srcCtxt = this.newSourceTx();
        try {
            this.data = this.getIds(srcCtxt);
            this.getReplicationModel().adjustOperations(this.data);
        }
        finally {
            TopiaReplicationContext.close(srcCtxt, true);
        }
    }

    public List<String> getEntityIds(Class<? extends TopiaEntity> type) throws TopiaException {
        List nodeEntityIds = (List)this.data.get(type);
        return nodeEntityIds;
    }

    public List<String> getEntityIds(ReplicationNode node) throws TopiaException {
        List<String> nodeEntityIds = this.getEntityIds(node.getEntityType());
        return nodeEntityIds;
    }

    public List<? extends TopiaEntity> getEntities(TopiaPersistenceContext tx, ReplicationNode node) throws TopiaException {
        List<String> nodeEntityIds = this.getEntityIds(node);
        if (nodeEntityIds == null) {
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will load " + nodeEntityIds.size() + " entities"));
        }
        List nodeEntities = TopiaEntityHelper.getEntitiesList((TopiaPersistenceContext)tx, (String[])nodeEntityIds.toArray(new String[nodeEntityIds.size()]));
        return nodeEntities;
    }

    public TopiaPersistenceContext newSourceTx() throws TopiaException {
        return this.sourceTx.newPersistenceContext();
    }

    public TopiaPersistenceContext newTargetTx() throws TopiaException {
        return this.targetTx.newPersistenceContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(TopiaPersistenceContext tx, boolean rollback) throws TopiaException {
        try {
            if (rollback) {
                tx.rollback();
            }
        }
        finally {
            tx.closeContext();
        }
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.treated != null) {
            this.treated.clear();
        }
    }

    protected TopiaEntityIdsMap getIds(TopiaPersistenceContext srcCtxt) throws TopiaException {
        TopiaEntityIdsMap data;
        if (this.replicationModel.isReplicateAll()) {
            data = new TopiaEntityIdsMap();
            for (TopiaEntityEnum e : this.replicationModel.getContracts()) {
                List ids = srcCtxt.getDao(e.getContract()).findAllIds();
                data.put((Object)e.getContract(), (Object)ids);
            }
        } else {
            TopiaEntity[] entities = TopiaEntityHelper.getEntities((TopiaPersistenceContext)srcCtxt, (String[])this.replicationModel.getTopiaIds());
            data = TopiaEntityHelper.detectEntityIds((TopiaEntityEnum[])this.replicationModel.getContracts(), this.replicationModel.getTypes(), (TopiaEntity[])entities);
        }
        return data;
    }

    protected List<ReplicationNode> getTreated() {
        if (this.treated == null) {
            this.treated = new ArrayList<ReplicationNode>();
        }
        return this.treated;
    }

    protected TopiaApplicationContext getSourceTx() {
        return this.sourceTx;
    }

    protected TopiaApplicationContext getTargetTx() {
        return this.targetTx;
    }

    protected TopiaEntityIdsMap getData() {
        return this.data;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

