/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.mappings;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.version.Version;
import org.nuiton.version.VersionBuilder;

public class TMSVersionHibernateDao {
    private static final Log log = LogFactory.getLog(TMSVersionHibernateDao.class);
    public static final String LEGACY_TABLE_NAME = "tmsVersion";
    public static final String TABLE_NAME = "tms_version";

    public static TMSVersion readVersion(Session session) throws TopiaException {
        try {
            Criteria criteria = session.createCriteria(TMSVersion.class);
            List list = criteria.list();
            TMSVersion result = list.isEmpty() ? null : (TMSVersion)list.get(0);
            return result;
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not obtain version", (Throwable)he);
        }
    }

    public static void createTMSSchema(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes.add(TargetType.STDOUT);
        }
        schemaExport.create(targetTypes, metadata);
    }

    public static void dropTMSSchema(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes.add(TargetType.STDOUT);
        }
        schemaExport.drop(targetTypes, metadata);
    }

    public static TMSVersion saveVersion(Session session, String version) throws TopiaException {
        try {
            TMSVersion result = TMSVersion.valueOf(version);
            session.save((Object)result);
            return result;
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not create version " + version, (Throwable)he);
        }
    }

    public static void update(Session session, TMSVersion version) throws TopiaException {
        try {
            session.saveOrUpdate((Object)version);
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not update version " + version, (Throwable)he);
        }
    }

    public static void deleteAll(Session session) throws TopiaException {
        try {
            Criteria criteria = session.createCriteria(TMSVersion.class);
            List list = criteria.list();
            for (Object o : list) {
                session.delete(o);
            }
        }
        catch (HibernateException he) {
            throw new TopiaException("Could not delete all versions", (Throwable)he);
        }
    }

    public static Version getVersion(Configuration hibernateConfiguration, Session session, String tableName) {
        try {
            String schemaName = TopiaUtil.getSchemaName((Configuration)hibernateConfiguration);
            GetVersionWork work = new GetVersionWork(schemaName, tableName);
            session.doWork((Work)work);
            Version v = work.getVersion();
            return v;
        }
        catch (HibernateException he) {
            throw new TopiaException("Can't obtain dbVersion for reason " + he.getMessage(), (Throwable)he);
        }
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    public static class GetVersionWork
    implements Work {
        protected Version version;
        private final String tableName;
        private final String schemaName;

        public GetVersionWork(String schemaName, String tableName) {
            this.tableName = tableName;
            this.schemaName = schemaName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) throws SQLException {
            String fullTableName = this.schemaName == null ? this.tableName : this.schemaName + "." + this.tableName;
            try (PreparedStatement st = connection.prepareStatement("select version from " + fullTableName + ";");){
                ResultSet set = st.executeQuery();
                if (set.next()) {
                    this.version = VersionBuilder.create((String)set.getString(1)).build();
                }
            }
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

