/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.text.WordUtils;
import org.nuiton.topia.persistence.TopiaEntity;

public class HqlAndParametersBuilder<E extends TopiaEntity> {
    protected Class<E> entityClass;
    protected Set<String> whereClauses = Sets.newLinkedHashSet();
    protected Map<String, Object> parameters = Maps.newLinkedHashMap();
    protected Set<String> orderByArguments;
    protected String alias = "topiaEntity_";

    public void setAlias(String alias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)alias));
        this.alias = alias;
    }

    public HqlAndParametersBuilder(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public void addNull(String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property));
        this.whereClauses.add(this.alias + "." + property + " is null");
    }

    public void addNotNull(String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property));
        this.whereClauses.add(this.alias + "." + property + " is not null");
    }

    public void addEquals(String property, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        if (value == null) {
            this.addNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " = :" + hqlParameterName);
        }
    }

    public void addNotEquals(String property, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        if (value == null) {
            this.addNotNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " != :" + hqlParameterName);
        }
    }

    public void addIn(String property, Collection<?> values) {
        this.addInOrNotIn(property, values, true);
    }

    public void addNotIn(String property, Collection<?> values) {
        this.addInOrNotIn(property, values, false);
    }

    protected void addInOrNotIn(String property, Collection<?> values, boolean in) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        Preconditions.checkNotNull(values);
        String aliasedProperty = this.alias + "." + property;
        int valuesSize = values.size();
        if (valuesSize == 0) {
            if (in) {
                this.whereClauses.add(" 0 = 1 ");
            } else {
                this.whereClauses.add(" 1 = 1 ");
            }
        } else if (valuesSize == 1) {
            Object onlyElement = Iterables.getOnlyElement(values);
            if (in) {
                this.addEquals(property, onlyElement);
            } else {
                this.addNotEquals(property, onlyElement);
            }
        } else {
            String whereClause;
            boolean propertyMayBeNull = values.contains(null);
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, values);
            if (in) {
                whereClause = String.format(" %s in ( :%s ) ", aliasedProperty, hqlParameterName);
                if (propertyMayBeNull) {
                    whereClause = whereClause + " or " + aliasedProperty + " is null";
                }
            } else {
                whereClause = String.format(" %s not in ( :%s ) ", aliasedProperty, hqlParameterName);
                if (propertyMayBeNull) {
                    whereClause = whereClause + " and " + aliasedProperty + " is not null";
                }
            }
            this.whereClauses.add(whereClause);
        }
    }

    public void addTopiaIdEquals(String property, String topiaId) {
        Preconditions.checkNotNull((Object)topiaId);
        this.addEquals(property + "." + "topiaId", topiaId);
    }

    public void addTopiaIdIn(String property, Collection<String> topiaIds) {
        this.addIn(property + "." + "topiaId", topiaIds);
    }

    public void addTopiaIdNotEquals(String property, String topiaId) {
        Preconditions.checkNotNull((Object)topiaId);
        this.addNotEquals(property + "." + "topiaId", topiaId);
    }

    public void addTopiaIdNotIn(String property, Collection<String> topiaIds) {
        this.addNotIn(property + "." + "topiaId", topiaIds);
    }

    public void addContains(String property, Object value) {
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(":" + hqlParameterName + " in elements(" + this.alias + "." + property + ")");
    }

    public void addNotContains(String property, Object value) {
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(":" + hqlParameterName + " not in elements(" + this.alias + "." + property + ")");
    }

    public void addLike(String property, String pattern) {
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, pattern);
        this.whereClauses.add(this.alias + "." + property + " like :" + hqlParameterName);
    }

    public void addNotLike(String property, String pattern) {
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, pattern);
        this.whereClauses.add(this.alias + "." + property + " not like :" + hqlParameterName);
    }

    public void addWhereClause(String whereClause) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)whereClause));
        this.whereClauses.add(whereClause);
    }

    public void addWhereClause(String whereClause, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull(hqlParameters);
        HashSet collisiontParameterNames = Sets.newHashSet((Iterable)Sets.intersection(this.parameters.keySet(), hqlParameters.keySet()));
        boolean noCollision = collisiontParameterNames.isEmpty();
        if (noCollision) {
            this.parameters.putAll(hqlParameters);
        } else {
            Object parameterValue;
            Sets.SetView noCollisiontParameterNames = Sets.difference(hqlParameters.keySet(), (Set)collisiontParameterNames);
            for (String parameterName : noCollisiontParameterNames) {
                parameterValue = hqlParameters.get(parameterName);
                this.parameters.put(parameterName, parameterValue);
            }
            for (String parameterName : collisiontParameterNames) {
                parameterValue = hqlParameters.get(parameterName);
                String newParameterName = this.putHqlParameterWithAvailableName(parameterName, parameterValue);
                whereClause = whereClause.replaceAll(":" + parameterName + "(?!\\w)", ":" + newParameterName);
            }
        }
        this.addWhereClause(whereClause);
    }

    public void setWhereClauses(Set<String> whereClauses) {
        Preconditions.checkNotNull(whereClauses);
        this.whereClauses = whereClauses;
    }

    public Set<String> getWhereClauses() {
        return this.whereClauses;
    }

    public void setParameters(Map<String, Object> parameters) {
        Preconditions.checkNotNull(parameters);
        this.parameters = parameters;
    }

    public void setOrderByArguments(Set<String> orderByArguments) {
        Preconditions.checkNotNull(orderByArguments);
        this.orderByArguments = orderByArguments;
    }

    public void setOrderByArguments(String ... orderByArguments) {
        LinkedHashSet orderByArgumentsAsSet = Sets.newLinkedHashSet();
        orderByArgumentsAsSet.addAll(Arrays.asList(orderByArguments));
        this.orderByArguments = orderByArgumentsAsSet;
    }

    public String getHql() {
        StringBuilder hqlStringBuilder = new StringBuilder();
        hqlStringBuilder.append("from ").append(this.entityClass.getCanonicalName()).append(" ").append(this.alias);
        if (this.whereClauses.size() == 1) {
            String whereClause = (String)Iterables.getOnlyElement(this.whereClauses);
            hqlStringBuilder.append(" where ").append(whereClause);
        } else if (!this.whereClauses.isEmpty()) {
            hqlStringBuilder.append(" where (").append(StringUtils.join(this.whereClauses, (String)") and (")).append(")");
        }
        if (CollectionUtils.isNotEmpty(this.orderByArguments)) {
            hqlStringBuilder.append(" order by ").append(this.alias).append(".").append(StringUtils.join(this.orderByArguments, (String)(", " + this.alias + ".")));
        }
        String hql = hqlStringBuilder.toString();
        return hql;
    }

    protected String getParameterName(String propertyName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)propertyName));
        String capitalize = WordUtils.capitalize((String)propertyName, (char[])new char[]{'.'});
        String withoutDots = capitalize.replaceAll("\\.", "");
        String parameterName = StringUtils.uncapitalize((String)withoutDots);
        return parameterName;
    }

    protected String putHqlParameterWithAvailableName(String propertyName, Object value) {
        String parameterNamePrefix = this.getParameterName(propertyName);
        int suffix = 0;
        String parameterName = parameterNamePrefix + suffix;
        while (this.parameters.containsKey(parameterName)) {
            parameterName = parameterNamePrefix + ++suffix;
        }
        this.parameters.put(parameterName, value);
        return parameterName;
    }

    public Map<String, Object> getHqlParameters() {
        return this.parameters;
    }

    public boolean isOrderByClausePresent() {
        return CollectionUtils.isNotEmpty(this.orderByArguments);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("hql", (Object)this.getHql()).append("hqlParameters", this.getHqlParameters()).toString();
    }
}

