/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.ObjectUtil;

public class EntityOperator<B extends TopiaEntity> {
    private static Log log = LogFactory.getLog(EntityOperator.class);
    protected final TopiaEntityEnum contract;
    protected List<String> properties;
    protected List<String> associationProperties;
    protected Method[] getMethods;
    protected Method[] setMethods;
    protected Method[] childGetMethods;
    protected Method[] childAddMethods;
    protected Method[] childAddAllMethods;
    protected Method[] childRemoveMethods;
    protected Method[] childSizeMethods;
    protected Method[] childIsEmptyMethods;
    protected Method[] childClearMethods;

    protected EntityOperator(TopiaEntityEnum contract) {
        if (contract == null) {
            throw new NullPointerException("'contract' parameter can not be null!");
        }
        this.contract = contract;
        this.init();
    }

    public Object get(String name, B bean) {
        int index = this.checkPropertyIndex(name);
        Object result = EntityOperator.invokeWithResult(this.getMethods[index], bean, new Object[0]);
        return result;
    }

    public void set(String name, B bean, Object value) {
        int index = this.checkPropertyIndex(name);
        EntityOperator.invoke(this.setMethods[index], bean, value);
    }

    public Map<String, Object> getNaturalId(B bean) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        String[] ids = this.contract.getNaturalIds();
        if (ids != null) {
            for (String id : ids) {
                result.put(id, this.get(id, bean));
            }
        }
        return result;
    }

    public void copy(String name, B from, B dst) {
        int index = this.checkPropertyIndex(name);
        Object value = EntityOperator.invokeWithResult(this.getMethods[index], from, new Object[0]);
        EntityOperator.invoke(this.setMethods[index], dst, value);
    }

    public void setNull(String name, B bean) {
        int index = this.checkPropertyIndex(name);
        Class<?> propertyType = this.getPropertyType(index);
        Method method = this.setMethods[index];
        Object nullValue = ObjectUtil.getNullValue(propertyType);
        EntityOperator.invoke(method, bean, nullValue);
    }

    public Object getChild(String name, B bean, String topiaId) {
        int index = this.checkAssociationPropertyIndex(name);
        Object result = EntityOperator.invokeWithResult(this.childGetMethods[index], bean, topiaId);
        return result;
    }

    public boolean isChildEmpty(String name, B bean) {
        int index = this.checkAssociationPropertyIndex(name);
        Boolean result = (Boolean)EntityOperator.invokeWithResult(this.childIsEmptyMethods[index], bean, new Object[0]);
        return result;
    }

    public void addChild(String name, B bean, Object child) {
        int index = this.checkAssociationPropertyIndex(name);
        EntityOperator.invoke(this.childAddMethods[index], bean, child);
    }

    public void addAllChild(String name, B bean, Collection<?> childs) {
        int index = this.checkAssociationPropertyIndex(name);
        EntityOperator.invoke(this.childAddAllMethods[index], bean, childs);
    }

    public void removeChild(String name, B bean, Object child) {
        int index = this.checkAssociationPropertyIndex(name);
        EntityOperator.invoke(this.childRemoveMethods[index], bean, child);
    }

    public int sizeChild(String name, B bean) {
        int index = this.checkAssociationPropertyIndex(name);
        Integer result = (Integer)EntityOperator.invokeWithResult(this.childSizeMethods[index], bean, new Object[0]);
        return result;
    }

    public void clearChild(String name, B bean) {
        int index = this.checkAssociationPropertyIndex(name);
        EntityOperator.invoke(this.childClearMethods[index], bean, new Object[0]);
    }

    public void copyProperties(B from, B dst, boolean tech, String ... properties) {
        if (tech) {
            TopiaEntityHelper.bindTechnical(from, dst);
        }
        if (from == null) {
            this.clearProperties(dst, properties);
        } else {
            Collection<String> names = this.getProperties(properties);
            for (String name : names) {
                this.copy(name, from, dst);
            }
        }
    }

    public Map<String, Object> obtainProperties(B from, String ... properties) {
        if (from == null) {
            return Collections.emptyMap();
        }
        Collection<String> names = this.getProperties(properties);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : names) {
            Object read = this.get(name, from);
            if (read == null) continue;
            result.put(name, read);
        }
        return result;
    }

    public void clearProperties(B from, String ... properties) {
        if (from == null) {
            return;
        }
        Collection<String> names = this.getProperties(properties);
        for (String name : names) {
            this.setNull(name, from);
        }
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public List<String> getAssociationProperties() {
        return this.associationProperties;
    }

    public Class<?> getPropertyType(String name) {
        int index = this.checkPropertyIndex(name);
        return this.getPropertyType(index);
    }

    public Class<?> getAssociationPropertyType(String name) {
        int index = this.checkAssociationPropertyIndex(name);
        return this.getAssociationPropertyType(index);
    }

    public Class<B> getClazz() {
        return this.contract.getContract();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof EntityOperator && this.contract == ((EntityOperator)obj).contract;
    }

    public int hashCode() {
        return this.contract.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("could not clone " + this + " for reason : " + e.getMessage(), e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.properties = null;
        this.associationProperties = null;
        this.getMethods = null;
        this.setMethods = null;
        this.childGetMethods = null;
        this.childAddMethods = null;
        this.childAddAllMethods = null;
        this.childRemoveMethods = null;
        this.childSizeMethods = null;
        this.childClearMethods = null;
        this.childIsEmptyMethods = null;
    }

    public String toString() {
        return super.toString() + '<' + this.getClazz() + '>';
    }

    protected Collection<String> getProperties(String[] properties) {
        List<String> names = null;
        names = properties.length == 0 ? this.properties : Arrays.asList(properties);
        return names;
    }

    protected Class<?> getPropertyType(int index) {
        Method method = this.getMethods[index];
        return method.getReturnType();
    }

    protected Class<?> getAssociationPropertyType(int index) {
        Method method = this.childGetMethods[index];
        return method.getReturnType();
    }

    protected B newInstance() {
        try {
            return (B)this.contract.getImplementation().newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void init() {
        ArrayList<Method> getters = new ArrayList<Method>();
        ArrayList<Method> setters = new ArrayList<Method>();
        ArrayList<Method> childGetters = new ArrayList<Method>();
        ArrayList<Method> childAdders = new ArrayList<Method>();
        ArrayList<Method> childAddersAll = new ArrayList<Method>();
        ArrayList<Method> childRemovers = new ArrayList<Method>();
        ArrayList<Method> childSize = new ArrayList<Method>();
        ArrayList<Method> childIsEmpty = new ArrayList<Method>();
        ArrayList<Method> childClearers = new ArrayList<Method>();
        HashSet explored = new HashSet();
        this.properties = new ArrayList<String>();
        this.associationProperties = new ArrayList<String>();
        try {
            int size;
            if (log.isDebugEnabled()) {
                log.debug((Object)("===== start for " + this.getClazz()));
            }
            this.init(this.getClazz(), explored, this.properties, this.associationProperties, getters, setters, childGetters, childAdders, childAddersAll, childRemovers, childSize, childClearers, childIsEmpty);
            if (!this.properties.isEmpty()) {
                size = this.properties.size();
                this.getMethods = getters.toArray(new Method[size]);
                this.setMethods = setters.toArray(new Method[size]);
                this.properties = Collections.unmodifiableList(this.properties);
            }
            if (!this.associationProperties.isEmpty()) {
                size = this.associationProperties.size();
                this.childGetMethods = childGetters.toArray(new Method[size]);
                this.childAddMethods = childAdders.toArray(new Method[size]);
                this.childAddAllMethods = childAddersAll.toArray(new Method[size]);
                this.childRemoveMethods = childRemovers.toArray(new Method[size]);
                this.childSizeMethods = childSize.toArray(new Method[size]);
                this.childIsEmptyMethods = childIsEmpty.toArray(new Method[size]);
                this.childClearMethods = childClearers.toArray(new Method[size]);
                this.associationProperties = Collections.unmodifiableList(this.associationProperties);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("===== end for " + this.getClazz() + " (" + this.properties.size() + " properties, " + this.associationProperties.size() + " associations)"));
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        finally {
            getters.clear();
            setters.clear();
            childGetters.clear();
            childAdders.clear();
            childAddersAll.clear();
            childRemovers.clear();
            childSize.clear();
            childClearers.clear();
            childIsEmpty.clear();
            explored.clear();
        }
    }

    private Method getMethod(String name, int nbParams, Method[] methodDescriptors) {
        for (Method m : methodDescriptors) {
            if (!name.equals(m.getName()) || m.getParameterTypes().length != nbParams) continue;
            return m;
        }
        return null;
    }

    private int checkPropertyIndex(String name) {
        int index = this.properties.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("property " + name + " is unknown for " + this);
        }
        return index;
    }

    private int checkAssociationPropertyIndex(String name) {
        int index = this.associationProperties.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("association property " + name + " is unknown for " + this);
        }
        return index;
    }

    protected static void invoke(Method m, Object bean, Object ... args) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)(bean.getClass() + "#" + m.getName()));
            }
            m.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <V> V invokeWithResult(Method m, Object bean, Object ... args) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)(bean.getClass() + "#" + m.getName()));
            }
            return (V)m.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init(Class<?> entityClass, Set<Class<?>> explored, List<String> properties, List<String> associationProperties, List<Method> getters, List<Method> setters, List<Method> childGetters, List<Method> childAdders, List<Method> childAddersAll, List<Method> childRemovers, List<Method> childSize, List<Method> childClearers, List<Method> childIsEmpty) throws IntrospectionException {
        if (entityClass == null) {
            throw new NullPointerException("entityClass can not be null!");
        }
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException("entityClass parameter " + entityClass + " is not interface!");
        }
        if (explored.contains(entityClass)) {
            return;
        }
        explored.add(entityClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter " + entityClass));
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(entityClass);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        Method[] methods = entityClass.getMethods();
        for (PropertyDescriptor propertydescriptor : propertyDescriptors) {
            String propertyName = propertydescriptor.getName();
            if (propertydescriptor.getReadMethod() != null && propertydescriptor.getWriteMethod() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("detected property : " + propertyName));
                }
                properties.add(propertyName);
                getters.add(propertydescriptor.getReadMethod());
                setters.add(propertydescriptor.getWriteMethod());
            }
            Class<?> propertyType = propertydescriptor.getPropertyType();
            String cap = StringUtils.capitalize((String)propertyName);
            if (!Collection.class.isAssignableFrom(propertyType)) continue;
            Method getMethod = this.getMethod("get" + cap + "ByTopiaId", 1, methods);
            Method addMethod = this.getMethod("add" + cap, 1, methods);
            Method addAllMethod = this.getMethod("addAll" + cap, 1, methods);
            Method removeMethod = this.getMethod("remove" + cap, 1, methods);
            Method sizeMethod = this.getMethod("size" + cap, 0, methods);
            Method clearMethod = this.getMethod("clear" + cap, 0, methods);
            Method isEmptyMethod = this.getMethod("is" + cap + "Empty", 0, methods);
            if (addMethod == null || addAllMethod == null || removeMethod == null || sizeMethod == null || getMethod == null || clearMethod == null || isEmptyMethod == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected association : " + propertyName));
            }
            childGetters.add(getMethod);
            childAdders.add(addMethod);
            childAddersAll.add(addAllMethod);
            childRemovers.add(removeMethod);
            childSize.add(sizeMethod);
            childClearers.add(clearMethod);
            childIsEmpty.add(isEmptyMethod);
            associationProperties.add(propertyName);
        }
        Class<?>[] interfaces = entityClass.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> c : interfaces) {
                if (TopiaEntity.class.equals(c) || !TopiaEntity.class.isAssignableFrom(c) || explored.contains(c)) continue;
                this.init(c, explored, properties, associationProperties, getters, setters, childGetters, childAdders, childAddersAll, childRemovers, childSize, childClearers, childIsEmpty);
            }
        }
    }
}

