/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class ServiceTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(ServiceTransformer.class);
    protected String modelName;
    protected String defaultPackageName;
    protected String exceptionName;
    private static final String OP_NAME_BEGIN_TRANSACTION = "beginTransaction";
    private static final String OP_NAME_COMMIT_TRANSACTION = "commitTransaction";
    private static final String OP_NAME_CLOSE_TRANSACTION = "closeTransaction";
    private static final String OP_NAME_TREATE_ERROR = "treateError";
    public static final String PARAMETER_TRANSACTION = "transaction";

    protected String getServiceAbstractClassName(String serviceName) {
        return serviceName + "Abstract";
    }

    public void transformFromModel(ObjectModel model) {
        this.exceptionName = TopiaGeneratorUtil.getExceptionClassTagValue(model);
        this.modelName = model.getName();
    }

    public void transformFromInterface(ObjectModelInterface input) {
        if (!TopiaGeneratorUtil.hasServiceStereotype((ObjectModelClassifier)input)) {
            return;
        }
        boolean needTransaction = this.isTransactionNeeded(input);
        ObjectModelInterface serviceContract = this.createServiceContract(input);
        this.createServiceAbstract(input, serviceContract, needTransaction);
    }

    protected ObjectModelInterface createServiceContract(ObjectModelInterface source) {
        ObjectModelInterface serviceContract = this.createInterface(source.getName(), source.getPackageName());
        this.setDocumentation((ObjectModelElement)serviceContract, source.getDocumentation());
        for (ObjectModelOperation op : source.getOperations()) {
            ObjectModelOperation newOp = this.addOperation((ObjectModelClassifier)serviceContract, op.getName(), op.getReturnType(), new ObjectModelModifier[0]);
            this.setDocumentation((ObjectModelElement)newOp.getReturnParameter(), op.getReturnParameter().getDocumentation());
            for (ObjectModelParameter param : op.getParameters()) {
                ObjectModelParameter newParam = this.addParameter(newOp, param.getType(), param.getName());
                this.setDocumentation((ObjectModelElement)newParam, param.getDocumentation());
            }
            for (String ex : op.getExceptions()) {
                this.addException(newOp, ex);
            }
            if (this.exceptionName != null) {
                this.addException(newOp, this.exceptionName);
            }
            this.setDocumentation((ObjectModelElement)newOp, op.getDocumentation());
        }
        return serviceContract;
    }

    protected void createBeginTransactionMethod(ObjectModelInterface source, ObjectModelInterface serviceContract, ObjectModelClass serviceAbstract) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_BEGIN_TRANSACTION, TopiaContext.class, new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addException(operation, TopiaException.class);
    }

    protected void createCommitTransactionMethod(ObjectModelClass serviceAbstract) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_COMMIT_TRANSACTION, "void", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        this.addParameter(operation, TopiaContext.class, PARAMETER_TRANSACTION);
        this.addException(operation, TopiaException.class);
        this.setOperationBody(operation, "\n        transaction.commitTransaction();\n");
    }

    protected void createCloseTransactionMethod(ObjectModelInterface source, ObjectModelInterface serviceContract, ObjectModelClass serviceAbstract) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_CLOSE_TRANSACTION, "void", new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addParameter(operation, TopiaContext.class, PARAMETER_TRANSACTION);
        this.addException(operation, TopiaException.class);
    }

    protected void createTreateErrorMethod(ObjectModelInterface source, ObjectModelInterface serviceContract, ObjectModelClass serviceAbstract, boolean needTransaction) {
        ObjectModelOperation treateError1 = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_TREATE_ERROR, "void", new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        if (needTransaction) {
            this.addParameter(treateError1, TopiaContext.class, PARAMETER_TRANSACTION);
        }
        this.addParameter(treateError1, Exception.class, "eee");
        this.addParameter(treateError1, String.class, "message");
        this.addParameter(treateError1, "Object...", "args");
        if (this.exceptionName != null) {
            this.addException(treateError1, this.exceptionName);
        }
        if (needTransaction) {
            ObjectModelOperation treateError2 = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_TREATE_ERROR, "void", new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
            this.addParameter(treateError2, Exception.class, "eee");
            this.addParameter(treateError2, String.class, "message");
            this.addParameter(treateError2, "Object...", "args");
            if (this.exceptionName != null) {
                this.addException(treateError2, this.exceptionName);
            }
            this.setOperationBody(treateError2, "\n            treateError(null, eee, message, args);\n        ");
        }
    }

    protected void createServiceAbstract(ObjectModelInterface source, ObjectModelInterface serviceContract, boolean needTransaction) {
        ObjectModelClass serviceAbstract = this.createAbstractClass(this.getServiceAbstractClassName(serviceContract.getName()), serviceContract.getPackageName());
        if (needTransaction) {
            this.addImport((ObjectModelClassifier)serviceAbstract, TopiaContext.class);
        }
        this.addImport((ObjectModelClassifier)serviceAbstract, I18n.class);
        this.addInterface((ObjectModelClassifier)serviceAbstract, serviceContract.getQualifiedName());
        if (needTransaction) {
            this.createBeginTransactionMethod(source, serviceContract, serviceAbstract);
            this.createCommitTransactionMethod(serviceAbstract);
            this.createCloseTransactionMethod(source, serviceContract, serviceAbstract);
        }
        this.createTreateErrorMethod(source, serviceContract, serviceAbstract, needTransaction);
        LinkedHashMap<ObjectModelOperation, ObjectModelOperation> abstractExecuteMethods = new LinkedHashMap<ObjectModelOperation, ObjectModelOperation>();
        for (ObjectModelOperation objectModelOperation : source.getOperations()) {
            ObjectModelOperation executeOp = this.createOperationExecuteAbstract(serviceAbstract, objectModelOperation, needTransaction);
            abstractExecuteMethods.put(objectModelOperation, executeOp);
        }
        for (Map.Entry entry : abstractExecuteMethods.entrySet()) {
            ObjectModelOperation operation = (ObjectModelOperation)entry.getKey();
            ObjectModelOperation executeOperation = (ObjectModelOperation)entry.getValue();
            this.createOperationImplementation(serviceAbstract, executeOperation, operation, source.getName(), needTransaction);
        }
    }

    protected ObjectModelOperation createOperationExecuteAbstract(ObjectModelClass serviceAbstract, ObjectModelOperation source, boolean needTransaction) {
        String opName = StringUtils.capitalize((String)source.getName());
        ObjectModelOperation executeOperation = this.addOperation((ObjectModelClassifier)serviceAbstract, "execute" + opName, source.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addException(executeOperation, Exception.class);
        if (needTransaction && this.isTransactionNeeded(source)) {
            this.addParameter(executeOperation, TopiaContext.class, PARAMETER_TRANSACTION);
        }
        if (this.isErrorArgsNeeded(source)) {
            this.addParameter(executeOperation, "java.util.List<Object>", "errorArgs");
        }
        for (ObjectModelParameter param : source.getParameters()) {
            this.addParameter(executeOperation, param.getType(), param.getName());
        }
        return executeOperation;
    }

    protected void createOperationImplementation(ObjectModelClass serviceAbstract, ObjectModelOperation abstOp, ObjectModelOperation source, String serviceContractName, boolean needTransaction) {
        needTransaction &= this.isTransactionNeeded(source);
        boolean needErrorArgs = this.isErrorArgsNeeded(source);
        ObjectModelOperation implOp = this.addOperation((ObjectModelClassifier)serviceAbstract, source.getName(), source.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)serviceAbstract, (ObjectModelElement)implOp, Override.class.getSimpleName());
        String toStringAppend = "";
        String separatorLog = " : ";
        for (ObjectModelParameter param : source.getParameters()) {
            String paramName = param.getName();
            this.addParameter(implOp, param.getType(), paramName);
        }
        StringBuilder buffer = new StringBuilder();
        String abstName = abstOp.getName();
        String abstParams = GeneratorUtil.getOperationParametersListName((ObjectModelOperation)abstOp);
        String abstReturnType = "";
        String abstReturn = "";
        String finalReturn = "";
        String returnType = GeneratorUtil.getSimpleName((String)abstOp.getReturnType(), (boolean)true);
        if (!returnType.equals("void")) {
            abstReturnType = returnType + " result = ";
            abstReturn = "return result;";
            finalReturn = "return " + this.getReturnValue(abstOp.getReturnType()) + ";";
        }
        String contract = GeneratorUtil.toLowerCaseFirstLetter((String)serviceContractName);
        String errorKey = StringUtils.lowerCase((String)this.modelName) + ".error." + contract + "." + source.getName();
        String treateErrorParams = "eee, I18n.n_(\"" + errorKey + "\")";
        if (needErrorArgs) {
            this.addImport((ObjectModelClassifier)serviceAbstract, ArrayList.class);
            buffer.append("\n        List<Object> errorArgs = new ArrayList<Object>();\n    ");
            treateErrorParams = treateErrorParams + ", errorArgs.toArray()";
        }
        if (needTransaction) {
            buffer.append("\n        TopiaContext transaction = null;\n        try {\n            transaction = beginTransaction();\n\n            try {");
            treateErrorParams = "transaction, " + treateErrorParams;
        } else {
            buffer.append("\n        try {\n    ");
        }
        String implName = StringUtils.capitalize((String)implOp.getName());
        String first = this.modelName.substring(0, 1);
        buffer.append("\n                " + abstReturnType + "" + abstName + "(" + abstParams + ");");
        if (needTransaction && this.isCommit(source, (ObjectModel)this.model)) {
            buffer.append("\n                commitTransaction(transaction);");
        }
        buffer.append("\n                " + abstReturn + "");
        if (needTransaction) {
            buffer.append("\n            } finally {\n                closeTransaction(transaction);\n            }\n     ");
        }
        for (String ex : source.getExceptions()) {
            this.addException(implOp, ex);
            String exName = GeneratorUtil.getSimpleName((String)ex);
            buffer.append("\n        } catch (" + exName + " eee) {\n" + "            throw eee; ");
        }
        if (this.exceptionName != null) {
            this.addException(implOp, this.exceptionName);
        }
        buffer.append("\n        } catch (Exception eee) {\n            treateError(" + treateErrorParams + "); ");
        buffer.append("\n        }\n        " + finalReturn + "\n" + "    ");
        this.setOperationBody(implOp, buffer.toString());
    }

    protected boolean isTransactionNeeded(ObjectModelInterface op) {
        boolean needTransaction = true;
        String transactionTag = TopiaGeneratorUtil.getTransactionTagValue((ObjectModelClassifier)op);
        if (transactionTag != null) {
            needTransaction = Boolean.parseBoolean(transactionTag);
        }
        return needTransaction;
    }

    protected boolean isTransactionNeeded(ObjectModelOperation op) {
        boolean needTransaction = true;
        String transactionTag = TopiaGeneratorUtil.getTransactionTagValue(op);
        if (transactionTag != null) {
            needTransaction = Boolean.parseBoolean(transactionTag);
        }
        return needTransaction;
    }

    protected boolean isCommit(ObjectModelOperation op, ObjectModel model) {
        boolean needCommit = false;
        String tagValue = TopiaGeneratorUtil.getDoCommitTagValue(op, model);
        if (tagValue != null) {
            needCommit = Boolean.parseBoolean(tagValue);
        }
        if (this.isVerbose()) {
            log.info((Object)("commit needed for op [" + op.getName() + "] : " + needCommit));
        }
        return needCommit;
    }

    protected boolean isErrorArgsNeeded(ObjectModelOperation op) {
        boolean needErrorArgs = false;
        String errorArgsTag = TopiaGeneratorUtil.getErrorArgsTagValue(op);
        if (errorArgsTag != null) {
            needErrorArgs = Boolean.parseBoolean(errorArgsTag);
        }
        return needErrorArgs;
    }

    protected String getReturnValue(String returnType) {
        try {
            Primitive prim = Primitive.valueOf(StringUtils.upperCase((String)returnType));
            return prim.getValue();
        }
        catch (IllegalArgumentException eee) {
            return null;
        }
    }

    protected static enum Primitive {
        BYTE("0"),
        SHORT("0"),
        INT("0"),
        LONG("0"),
        FLOAT("0."),
        DOUBLE("0."),
        CHAR("''"),
        BOOLEAN("false");

        private String value;

        private Primitive(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

