/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceTransformer
extends ObjectModelTransformerToJava {
    protected String modelName;
    protected String defaultPackageName;
    protected String exceptionName;
    private static final String OP_NAME_BEGIN_TRANSACTION = "beginTransaction";
    private static final String OP_NAME_CLOSE_TRANSACTION = "closeTransaction";
    private static final String OP_NAME_TREATE_ERROR = "treateError";

    protected String getServiceAbstractClassName(String serviceName) {
        return serviceName + "Abstract";
    }

    public void transformFromModel(ObjectModel model) {
        this.exceptionName = model.getTagValue("exceptionClass");
        this.modelName = model.getName();
    }

    public void transformFromInterface(ObjectModelInterface interfacez) {
        if (!interfacez.hasStereotype("service")) {
            return;
        }
        ObjectModelInterface serviceContract = this.createServiceContract(interfacez);
        this.createServiceAbstract(interfacez, serviceContract);
    }

    protected ObjectModelInterface createServiceContract(ObjectModelInterface source) {
        ObjectModelInterface serviceContract = this.createInterface(source.getName(), source.getPackageName());
        this.setDocumentation((ObjectModelElement)serviceContract, source.getDocumentation());
        for (ObjectModelOperation op : source.getOperations()) {
            ObjectModelOperation newOp = this.addOperation((ObjectModelClassifier)serviceContract, op.getName(), op.getReturnType(), new ObjectModelModifier[0]);
            this.setDocumentation((ObjectModelElement)newOp.getReturnParameter(), op.getReturnParameter().getDocumentation());
            for (ObjectModelParameter param : op.getParameters()) {
                ObjectModelParameter newParam = this.addParameter(newOp, param.getType(), param.getName());
                this.setDocumentation((ObjectModelElement)newParam, param.getDocumentation());
            }
            for (String ex : op.getExceptions()) {
                this.addException(newOp, ex);
            }
            if (this.exceptionName != null) {
                this.addException(newOp, this.exceptionName);
            }
            this.setDocumentation((ObjectModelElement)newOp, op.getDocumentation());
        }
        return serviceContract;
    }

    protected void createServiceAbstract(ObjectModelInterface source, ObjectModelInterface serviceContract) {
        ObjectModelClass serviceAbstract = this.createAbstractClass(this.getServiceAbstractClassName(serviceContract.getName()), serviceContract.getPackageName());
        this.addInterface((ObjectModelClassifier)serviceAbstract, serviceContract.getQualifiedName());
        this.addAttribute((ObjectModelClassifier)serviceAbstract, "log", Log.class, null, new ObjectModelModifier[]{ObjectModelModifier.PRIVATE, ObjectModelModifier.FINAL});
        this.addImport((ObjectModelClassifier)serviceAbstract, Log.class);
        this.addImport((ObjectModelClassifier)serviceAbstract, LogFactory.class);
        ObjectModelOperation constructor = this.addConstructor(serviceAbstract, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n        // FIXME : must be fixed attribute value in EUGene\n        this.log = LogFactory.getLog(" + serviceAbstract.getName() + ".class);\n" + "    ");
        ObjectModelOperation beginTransaction = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_BEGIN_TRANSACTION, TopiaContext.class, new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addException(beginTransaction, TopiaException.class);
        ObjectModelOperation treateError1 = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_TREATE_ERROR, "void", new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addParameter(treateError1, Exception.class, "eee");
        this.addParameter(treateError1, String.class, "message");
        this.addParameter(treateError1, "Object...", "args");
        if (this.exceptionName != null) {
            this.addException(treateError1, this.exceptionName);
        }
        ObjectModelOperation treateError2 = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_TREATE_ERROR, "void", new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addParameter(treateError2, TopiaContext.class, "transaction");
        this.addParameter(treateError2, Exception.class, "eee");
        this.addParameter(treateError2, String.class, "message");
        this.addParameter(treateError2, "Object...", "args");
        if (this.exceptionName != null) {
            this.addException(treateError2, this.exceptionName);
        }
        ObjectModelOperation closeTransaction = this.addOperation((ObjectModelClassifier)serviceAbstract, OP_NAME_CLOSE_TRANSACTION, "void", new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addParameter(closeTransaction, TopiaContext.class, "transaction");
        HashMap<String, ObjectModelOperation> abstOps = new HashMap<String, ObjectModelOperation>();
        for (ObjectModelOperation op : source.getOperations()) {
            ObjectModelOperation abstOp = this.createOperationExecuteAbstract(serviceAbstract, op);
            abstOps.put(op.getName(), abstOp);
        }
        this.addImport((ObjectModelClassifier)serviceAbstract, TopiaContext.class);
        this.addImport((ObjectModelClassifier)serviceAbstract, I18n.class);
        this.addImport((ObjectModelClassifier)serviceAbstract, ArrayList.class);
        this.addImport((ObjectModelClassifier)serviceAbstract, DurationFormatUtils.class);
        for (ObjectModelOperation op : source.getOperations()) {
            this.createOperationImplementation(serviceAbstract, (ObjectModelOperation)abstOps.get(op.getName()), op, source.getName());
        }
    }

    protected ObjectModelOperation createOperationExecuteAbstract(ObjectModelClass serviceAbstract, ObjectModelOperation source) {
        String opName = StringUtils.capitalize((String)source.getName());
        ObjectModelOperation abstOp = this.addOperation((ObjectModelClassifier)serviceAbstract, "execute" + opName, source.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.ABSTRACT, ObjectModelModifier.PROTECTED});
        this.addException(abstOp, Exception.class);
        if (this.isTransactionNeeded(source)) {
            this.addParameter(abstOp, TopiaContext.class, "transaction");
        }
        if (this.isErrorArgsNeeded(source)) {
            this.addParameter(abstOp, "java.util.List<Object>", "errorArgs");
        }
        for (ObjectModelParameter param : source.getParameters()) {
            this.addParameter(abstOp, param.getType(), param.getName());
        }
        return abstOp;
    }

    protected void createOperationImplementation(ObjectModelClass serviceAbstract, ObjectModelOperation abstOp, ObjectModelOperation source, String serviceContractName) {
        boolean needTransaction = this.isTransactionNeeded(source);
        boolean needErrorArgs = this.isErrorArgsNeeded(source);
        ObjectModelOperation implOp = this.addOperation((ObjectModelClassifier)serviceAbstract, source.getName(), source.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)serviceAbstract, (ObjectModelElement)implOp, Override.class.getSimpleName());
        String toStringAppend = "";
        String separatorLog = " : ";
        for (ObjectModelParameter param : source.getParameters()) {
            String paramName = param.getName();
            this.addParameter(implOp, param.getType(), paramName);
            toStringAppend = toStringAppend + "\n\t\t\t.append(\"" + separatorLog + paramName + " = \")" + ".append(" + paramName + ")";
            separatorLog = " _ ";
        }
        StringBuilder buffer = new StringBuilder();
        String abstName = abstOp.getName();
        String abstParams = "";
        String separator = "";
        for (ObjectModelParameter param : abstOp.getParameters()) {
            abstParams = abstParams + separator + param.getName();
            separator = ", ";
        }
        String abstReturnType = "";
        String abstReturn = "";
        String finalReturn = "";
        if (!abstOp.getReturnType().equals("void")) {
            abstReturnType = GeneratorUtil.getSimpleName((String)abstOp.getReturnType()) + " result = ";
            abstReturn = "return result;";
            finalReturn = "return " + this.getReturnValue(abstOp.getReturnType()) + ";";
        }
        String contract = GeneratorUtil.toLowerCaseFirstLetter((String)serviceContractName);
        String errorKey = StringUtils.lowerCase((String)this.modelName) + ".error." + contract + "." + source.getName();
        String treateErrorParams = "eee, I18n.n_(\"" + errorKey + "\")";
        if (needErrorArgs) {
            buffer.append("\n        List<Object> errorArgs = new ArrayList<Object>();\n    ");
            treateErrorParams = treateErrorParams + ", errorArgs.toArray()";
        }
        if (needTransaction) {
            buffer.append("\n        TopiaContext transaction = null;\n        try {\n            transaction = beginTransaction();\n    ");
            treateErrorParams = "transaction, " + treateErrorParams;
        } else {
            buffer.append("\n        try {\n    ");
        }
        String implName = StringUtils.capitalize((String)implOp.getName());
        String first = this.modelName.substring(0, 1);
        buffer.append("\n            long startTime = 0;\n            if (log.isDebugEnabled()) {\n                log.debug(\"" + first + ":[ begin " + implName + " ]\");\n" + "                startTime = System.currentTimeMillis();\n" + "            }\n" + "            if (log.isTraceEnabled()) {\n" + "                String message = new StringBuilder(\"# ARGS >\")" + toStringAppend + ".\n" + "                    toString();\n" + "                log.trace(message);\n" + "            }\n" + "\n" + "            " + abstReturnType + "" + abstName + "(" + abstParams + ");\n" + "            if (log.isDebugEnabled()) {\n" + "                long stopTime = System.currentTimeMillis();\n" + "                log.debug(\"" + first + ":[ end " + implName + " ] Time = \" +\n" + "                        DurationFormatUtils.formatDurationHMS(\n" + "                                stopTime - startTime));\n" + "            }\n" + "            " + abstReturn + " ");
        for (String ex : source.getExceptions()) {
            this.addException(implOp, ex);
            String exName = GeneratorUtil.getSimpleName((String)ex);
            buffer.append("\n        } catch (" + exName + " eee) {\n" + "            throw eee; ");
        }
        buffer.append("\n        } catch (Exception eee) {\n            treateError(" + treateErrorParams + "); ");
        if (needTransaction) {
            buffer.append("\n        } finally {\n            closeTransaction(transaction); ");
        }
        buffer.append("\n        }\n        " + finalReturn + "\n" + "    ");
        this.setOperationBody(implOp, buffer.toString());
    }

    protected boolean isTransactionNeeded(ObjectModelOperation op) {
        boolean needTransaction = true;
        String transactionTag = op.getTagValue("transaction");
        if (transactionTag != null) {
            needTransaction = Boolean.parseBoolean(transactionTag);
        }
        return needTransaction;
    }

    protected boolean isErrorArgsNeeded(ObjectModelOperation op) {
        boolean needErrorArgs = false;
        String errorArgsTag = op.getTagValue("errorArgs");
        if (errorArgsTag != null) {
            needErrorArgs = Boolean.parseBoolean(errorArgsTag);
        }
        return needErrorArgs;
    }

    protected String getReturnValue(String returnType) {
        try {
            Primitive prim = Primitive.valueOf(StringUtils.upperCase((String)returnType));
            return prim.getValue();
        }
        catch (IllegalArgumentException eee) {
            return null;
        }
    }

    protected static enum Primitive {
        BYTE("0"),
        SHORT("0"),
        INT("0"),
        LONG("0"),
        FLOAT("0."),
        DOUBLE("0."),
        CHAR("''"),
        BOOLEAN("false");

        private String value;

        private Primitive(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

