/**
 * *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.persistence.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

/**
 * Pour qualifier l'etat d'une entite lors du calcul d'un differentiel entre
 * deux entites.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see TopiaEntityHelper#buildDifferentiel(List, List)
 * @since 2.2.0
 */
public enum DiffState {

    /**
     * nouvel entite dans le storage de reference.
     * <p/>
     * A ajouter dans le storage local.
     */
    NEW,
    /**
     * entite modifie dans le storage de reference (voir topiaVersion).
     * <p/>
     * A mettre a jour dans le storage local.
     */
    MODIFIED,
    /**
     * entité supprimée dans le storage de reference.
     * <p/>
     * A supprimer du storage local (apres remplacement par autre chose...)
     */
    REMOVED;

    /**
     * Construit un dictionnaire avec pour tous les états une liste vide.
     *
     * @return le dictionnaire crée
     */
    public static EnumMap<DiffState, List<String>> newMap() {
        EnumMap<DiffState, List<String>> result =
                new EnumMap<DiffState, List<String>>(DiffState.class);
        for (DiffState state : values()) {
            result.put(state, new ArrayList<String>());
        }
        return result;
    }

    /**
     * Ajoute dans le premier dictionnaire, les listes du second dictionnaire.
     *
     * @param mainMap le dictionnaire principale
     * @param toAdd   le dictionne a ajouter dans le dictionnaire principale
     */
    public static void addAll(EnumMap<DiffState, List<String>> mainMap,
                              EnumMap<DiffState, List<String>> toAdd) {
        for (DiffState state : values()) {
            List<String> newList = toAdd.get(state);
            if (newList != null && !newList.isEmpty()) {
                mainMap.get(state).addAll(newList);
            }
        }
    }

    /**
     * Nettoye un dictionnaire donnee de toute ses donnees.
     *
     * @param mainMap le dictionnaire a nettoyer.
     */
    public static void clear(EnumMap<DiffState, List<String>> mainMap) {
        for (DiffState state : values()) {
            List<String> newList = mainMap.get(state);
            if (newList != null) {
                newList.clear();
            }
            mainMap.remove(state);
        }
    }

    /**
     * Supprime toutes les entrees vides du dictionnaire .
     *
     * @param mainMap le dictionnaire a nettoyer
     */
    public static void removeEmptyStates(
            EnumMap<DiffState, List<String>> mainMap) {
        for (DiffState state : values()) {
            List<String> newList = mainMap.get(state);
            if (newList == null || newList.isEmpty()) {
                mainMap.remove(state);
            }
        }
    }
}
