/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.Product;

public abstract class DepartmentAbstract
extends TopiaEntityAbstract
implements Department {
    public String name;
    public Employe leader;
    public Company company;
    public Collection<Product> product;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Department.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Department.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "leader", Employe.class, (Object)this.leader);
        visitor.visit((TopiaEntity)this, "company", Company.class, (Object)this.company);
        visitor.visit((TopiaEntity)this, "product", Collection.class, Product.class, this.product);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> accept() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setLeader(Employe value) {
        Employe _oldValue = this.leader;
        this.fireOnPreWrite("leader", _oldValue, value);
        this.leader = value;
        this.fireOnPostWrite("leader", _oldValue, value);
    }

    @Override
    public Employe getLeader() {
        this.fireOnPreRead("leader", this.leader);
        Employe result = this.leader;
        this.fireOnPostRead("leader", this.leader);
        return result;
    }

    @Override
    public void setCompany(Company value) {
        Company _oldValue = this.company;
        this.fireOnPreWrite("company", _oldValue, value);
        this.company = value;
        this.fireOnPostWrite("company", _oldValue, value);
    }

    @Override
    public Company getCompany() {
        this.fireOnPreRead("company", this.company);
        Company result = this.company;
        this.fireOnPostRead("company", this.company);
        return result;
    }

    @Override
    public void addProduct(Product product) {
        this.fireOnPreWrite("product", null, product);
        if (this.product == null) {
            this.product = new ArrayList<Product>();
        }
        this.product.add(product);
        this.fireOnPostWrite("product", this.product.size(), null, product);
    }

    @Override
    public void addAllProduct(Collection<Product> values) {
        if (values == null) {
            return;
        }
        for (Product item : values) {
            this.addProduct(item);
        }
    }

    @Override
    public Product getProductByTopiaId(String topiaId) {
        return (Product)TopiaEntityHelper.getEntityByTopiaId(this.product, (String)topiaId);
    }

    @Override
    public void setProduct(Collection<Product> values) {
        Collection<Product> _oldValue = this.product;
        this.fireOnPreWrite("product", _oldValue, values);
        this.product = values;
        this.fireOnPostWrite("product", _oldValue, values);
    }

    @Override
    public void removeProduct(Product value) {
        this.fireOnPreWrite("product", value, null);
        if (this.product == null || !this.product.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("product", this.product.size() + 1, value, null);
    }

    @Override
    public void clearProduct() {
        if (this.product == null) {
            return;
        }
        ArrayList<Product> _oldValue = new ArrayList<Product>(this.product);
        this.fireOnPreWrite("product", _oldValue, this.product);
        this.product.clear();
        this.fireOnPostWrite("product", _oldValue, this.product);
    }

    @Override
    public Collection<Product> getProduct() {
        return this.product;
    }

    @Override
    public int sizeProduct() {
        if (this.product == null) {
            return 0;
        }
        return this.product.size();
    }

    @Override
    public boolean isProductEmpty() {
        int size = this.sizeProduct();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("leader", (Object)this.leader).append("product", this.product).toString();
        return result;
    }

    static {
        I18n.n_((String)"topia.test.common.department");
        I18n.n_((String)"topia.test.common.name");
        I18n.n_((String)"topia.test.common.leader");
        I18n.n_((String)"topia.test.common.company");
        I18n.n_((String)"topia.test.common.product");
    }
}

