package org.nuiton.topiatest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class DepartmentAbstract extends TopiaEntityAbstract implements Department {

    public String name;
    public Employe leader;
    public Company company;
    public Collection<Product> product;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Department.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Department.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, LEADER, Employe.class, leader);
        visitor.visit(this, COMPANY, Company.class, company);
        visitor.visit(this, PRODUCT, Collection.class, Product.class, product);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setLeader :
     * @param value 
     */

    public void setLeader(Employe value) {
        Employe _oldValue = this.leader;
        fireOnPreWrite(LEADER, _oldValue, value);
        this.leader = value;
        fireOnPostWrite(LEADER, _oldValue, value);
}

    /**
     * getLeader :
     * @return Employe 
     */

    public Employe getLeader() {
        fireOnPreRead(LEADER, leader);
        Employe result = this.leader;
        fireOnPostRead(LEADER, leader);
        return result;
}

    /**
     * setCompany :
     * @param value 
     */

    public void setCompany(Company value) {
        Company _oldValue = this.company;
        fireOnPreWrite(COMPANY, _oldValue, value);
        this.company = value;
        fireOnPostWrite(COMPANY, _oldValue, value);
}

    /**
     * getCompany :
     * @return Company 
     */

    public Company getCompany() {
        fireOnPreRead(COMPANY, company);
        Company result = this.company;
        fireOnPostRead(COMPANY, company);
        return result;
}

    /**
     * addProduct :
     * @param product 
     */

    public void addProduct(Product product) {    
        fireOnPreWrite(PRODUCT, null, product);
        if (this.product == null) {
            this.product = new ArrayList<Product>();
        }
        this.product.add(product);
        fireOnPostWrite(PRODUCT, this.product.size(), null, product);
}

    /**
     * addAllProduct :
     * @param values 
     */

    public void addAllProduct(Collection<Product> values) {
        if (values == null) {
            return;
        }
        for (Product item : values) {
            addProduct(item);
        }
}

    /**
     * getProductByTopiaId :
     * @param topiaId 
     * @return Product 
     */

    public Product getProductByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(product, topiaId);
 }

    /**
     * setProduct :
     * @param values 
     */

    public void setProduct(Collection<Product> values) {
        Collection<Product> _oldValue = product;
        fireOnPreWrite(PRODUCT, _oldValue, values);
        product = values;
        fireOnPostWrite(PRODUCT, _oldValue, values);
}

    /**
     * removeProduct :
     * @param value 
     */

    public void removeProduct(Product value) {
        fireOnPreWrite(PRODUCT, value, null);
        if ((this.product == null) || (!this.product.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(PRODUCT, this.product.size()+1, value, null);
}

    /**
     * clearProduct :
     */

    public void clearProduct() {
        if (this.product == null) {
            return;
        }
        Collection<Product> _oldValue = new ArrayList<Product>(this.product);
        fireOnPreWrite(PRODUCT, _oldValue, this.product);
        this.product.clear();
        fireOnPostWrite(PRODUCT, _oldValue, this.product);
}

    /**
     * getProduct :
     * @return Collection<Product> 
     */

    public Collection<Product> getProduct() {
        return product;
}

    /**
     * sizeProduct :
     * @return int 
     */

    public int sizeProduct() {
        if (product == null) {
            return 0;
        }
        return product.size();
}

    /**
     * isProductEmpty :
     * @return boolean 
     */

    public boolean isProductEmpty() {
        int size = sizeProduct();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(LEADER, this.leader).
            append(PRODUCT, this.product).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.department");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.leader");
    org.nuiton.i18n.I18n.n_("topia.test.common.company");
    org.nuiton.i18n.I18n.n_("topia.test.common.product");
    }

} //DepartmentAbstract
