/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
* EntityPOJOGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1558 $
*
* Mise a jour: $Date: 2009-06-11 06:53:44 +0200 (jeu., 11 juin 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

import org.nuiton.eugene.Generator;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityImplGenerator extends ObjectModelGenerator {

    private static final Log log = LogFactory.getLog(EntityImplGenerator.class);

    public EntityImplGenerator() {
        super();
    }

    public EntityImplGenerator(Generator parent) {
        super(parent);
    }

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "Impl.java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        // On ne génère pas le impl si l'entité a des opérations qui ne sont pas seulement pour le DAO
        if (clazz.getOperations().size() > 0 && !hasOnlyDAOOperations(clazz)) {
            return;
        }
        //De même, on ne génère pas le impl si il y a des opérations venant des
        // superclasses non implémentées
        for (ObjectModelOperation otherOp  : clazz.getAllOtherOperations(false)) {            
            if (otherOp.isAbstract()) {
                return;
            }
        }

        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        String abstractStr = isAbstract(clazz)?"abstract ":" ";
output.write("package "+clazz.getPackageName()+";\n");
output.write("\n");
output.write("import java.io.Serializable;\n");
output.write("\n");
output.write("/**\n");
output.write(" * Implantation des operations pour l'entité "+TopiaGeneratorUtil.capitalize(clazz.getName())+".\n");
output.write(" */\n");
output.write("public "+abstractStr+"class "+clazzName+"Impl extends "+clazzFQN+"Abstract implements Serializable, "+clazzFQN+" {\n");
output.write("\n");
output.write("    private static final long serialVersionUID = 1L;\n");
output.write("\n");
output.write("");

output.write("} //"+clazzName+"Impl\n");
output.write("");
    }


    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }

        //Une classe peut être abstraite si elle a des méthodes définies dans
        // ses superinterface et non implantées dans ses superclasses        
        Collection<ObjectModelOperation> allInterfaceOperations = clazz.getAllInterfaceOperations(true);
        allInterfaceOperations.removeAll(clazz.getAllOtherOperations(true));
        for (ObjectModelOperation op : allInterfaceOperations) {
            boolean implementationFound = false;
            for (ObjectModelClass superClazz : clazz.getSuperclasses()) {
                for (ObjectModelOperation matchingOp : superClazz.getOperations(op.getName())) {
                    implementationFound = (op.equals(matchingOp) && !matchingOp.isAbstract());
                    if (implementationFound) {
                        break;
                    }
                }
                if (implementationFound) {
                    break;
                }
            }            
            if (!implementationFound) {
                log.info(clazz.getName()+" : abstract operation "+op);
                return true;
            }
        }
        return false;
    }

    /**
     * Detect if the clazz has only operations for DAO implementation.
     * These operations are identified with the stereotype <<dao>>.
     * @param clazz The ObjectModelClass with all operations.
     * @return true if there is only dao operations, false if there is no operations or some without
     * dao stereotype.
     */
    public static boolean hasOnlyDAOOperations(ObjectModelClass clazz) {
        boolean res = true;
        Collection<ObjectModelOperation> operations = clazz.getOperations();
        if (operations.size() == 0) {
            res = false;
        }
        for (ObjectModelOperation op : operations) {
            res &= op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO);
        }
        return res;
    }

} //EntityImplGenerator
