/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.eugene.Generator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.util.StringUtil;

public class DAOAbstractGenerator
extends ObjectModelGenerator {
    public DAOAbstractGenerator() {
    }

    public DAOAbstractGenerator(Generator parent) {
        super(parent);
    }

    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DAOAbstract.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        boolean enableSecurity;
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright((Model)this.model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + clazz.getPackageName() + ";\n");
        output.write("\n");
        output.write("import java.util.List;\n");
        output.write("\n");
        output.write("");
        Collection<ObjectModelOperation> DAOoperations = DAOAbstractGenerator.getDAOOperations(clazz);
        if (this.isCollectionNeeded(DAOoperations)) {
            output.write("\n");
            output.write("import java.util.Collection;\n");
            output.write("");
        }
        if (this.isSetNeeded(DAOoperations)) {
            output.write("\n");
            output.write("import java.util.Set;\n");
            output.write("");
        }
        output.write("\n");
        output.write("import java.util.Arrays;\n");
        output.write("import org.nuiton.topia.TopiaException;\n");
        output.write("import org.nuiton.topia.framework.TopiaContextImplementor;\n");
        output.write("");
        boolean bl = enableSecurity = clazz.hasTagValue("securityCreate") || clazz.hasTagValue("securityLoad") || clazz.hasTagValue("securityUpdate") || clazz.hasTagValue("securityDelete");
        if (enableSecurity) {
            output.write("\n");
            output.write("import java.util.ArrayList;\n");
            output.write("import java.security.Permission;\n");
            output.write("import org.nuiton.topia.taas.entities.TaasAuthorizationImpl;\n");
            output.write("import org.nuiton.topia.taas.jaas.TaasPermission;\n");
            output.write("import org.nuiton.topia.persistence.TopiaDAO;\n");
            output.write("import static org.nuiton.topia.taas.TaasUtil.CREATE;\n");
            output.write("import static org.nuiton.topia.taas.TaasUtil.DELETE;\n");
            output.write("import static org.nuiton.topia.taas.TaasUtil.LOAD;\n");
            output.write("import static org.nuiton.topia.taas.TaasUtil.UPDATE;\n");
            output.write("");
        }
        String clazzName = clazz.getName();
        output.write("\n");
        output.write("/**\n");
        output.write(" * Implantation DAO pour l'entit\u00e9 " + GeneratorUtil.toUpperCaseFirstLetter((String)clazz.getName()) + ".\n");
        output.write(" * Cette classe contient une implantation de TopiaDAO a laquel elle peut\n");
        output.write(" * deleguer des traitements\n");
        output.write(" * \n");
        output.write(" */\n");
        output.write("public abstract class " + clazzName + "DAOAbstract<E extends " + clazzName + "> extends ");
        String extendClass = "";
        Iterator i = clazz.getSuperclasses().iterator();
        while (i.hasNext()) {
            ObjectModelClassifier parent = (ObjectModelClassifier)i.next();
            extendClass = extendClass + parent.getQualifiedName();
            if (parent.hasStereotype("entity")) {
                extendClass = extendClass + "DAOImpl<E>";
            }
            if (!i.hasNext()) continue;
            extendClass = extendClass + ", ";
        }
        if (extendClass.length() == 0) {
            extendClass = extendClass + "org.nuiton.topia.persistence.TopiaDAOImpl<E>";
        }
        output.write("" + extendClass + " implements org.nuiton.topia.persistence.TopiaDAO<E> {    \n");
        output.write("\n");
        output.write("    public Class<E> getEntityClass() {\n");
        output.write("        return (Class<E>)" + clazzName + ".class;\n");
        output.write("    }\n");
        output.write("");
        this.generateDAOOperations(output, DAOoperations);
        output.write("\n");
        output.write("    public void delete(E entity) throws TopiaException {\n");
        output.write("");
        String modelName = GeneratorUtil.capitalize((String)this.model.getName());
        String providerFQN = this.getProperty("defaultPackage") + "." + modelName + "DAOHelper.getImplementationClass";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String attrType = attr.getType();
            String reverseAttrName = attr.getReverseAttributeName();
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.hasAssociationClass() && reverse != null && reverse.isNavigable() && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                String attrDBName = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr);
                String attrClassifierDBName = TopiaGeneratorUtil.getDBName((ObjectModelElement)attr.getClassifier());
                String attrJoinTableName = TopiaGeneratorUtil.getManyToManyTableName(attr);
                String attrReverseDBName = TopiaGeneratorUtil.getReverseDBName(attr);
                output.write("\n");
                output.write("        {\n");
                output.write("            List<" + attrType + "> list = getContext().getHibernate().createSQLQuery(\n");
                output.write("                    \"SELECT main.topiaid \" +\n");
                output.write("                    \"from " + attrClassifierDBName + " main, " + attrJoinTableName + " secondary \" +\n");
                output.write("                    \"where main.topiaid=secondary." + attrDBName + "\" +\n");
                output.write("                    \" and secondary." + attrReverseDBName + "='\" + entity.getTopiaId() + \"'\")\n");
                output.write("                    .addEntity(\"main\", " + providerFQN + "(" + attrType + ".class)).list();\n");
                output.write("            for (" + attrType + " item : list) {\n");
                output.write("                item.remove" + TopiaGeneratorUtil.capitalize(reverseAttrName) + "(entity);\n");
                output.write("            }\n");
                output.write("        }\n");
                output.write("");
                continue;
            }
            if (attr.hasAssociationClass() || reverse == null || !reverse.isNavigable() || GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) continue;
            output.write("\n");
            output.write("                {\n");
            output.write("                List<" + attrType + "> list = getContext()\n");
            output.write("                            .getDAO(" + attrType + ".class)\n");
            output.write("                            .findAllByProperties(\"" + reverseAttrName + "\", entity);\n");
            output.write("                    for (" + attrType + " item : list) {\n");
            output.write("                        item.set" + GeneratorUtil.capitalize((String)reverseAttrName) + "(null);\n");
            output.write("");
            if (attr.isAggregate()) {
                output.write("\n");
                output.write("            \t\t\titem.delete();\n");
                output.write("");
            }
            output.write("\n");
            output.write("                    }\n");
            output.write("                }\n");
            output.write("        ");
        }
        output.write("        \n");
        output.write("        super.delete(entity);\n");
        output.write("    }    \n");
        output.write("     \n");
        output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            String attrName = attr.getName();
            output.write("    /**\n");
            output.write("     * Recherche sur l'attribut " + attrName + "\n");
            output.write("     */\n");
            output.write("");
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                this.generateNoNMultiplicity(output, attr, false);
                continue;
            }
            this.generateNMultiplicity(output, attr);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assocClass = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assocClass.getParticipantsAttributes()) {
                if (attr == null) continue;
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    this.generateNoNMultiplicity(output, attr, true);
                    continue;
                }
                this.generateNMultiplicity(output, attr);
            }
        }
        if (enableSecurity) {
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas\n");
            output.write("     * @param topiaId topiaId d'une entite\n");
            output.write("     * @param actions actions souhait\u00e9es\n");
            output.write("     * @return la liste des permissions\n");
            output.write("     */\n");
            output.write("    public List<Permission> getRequestPermission(String topiaId, int actions) throws TopiaException {\n");
            output.write("        List<Permission> resultPermissions = new ArrayList<Permission>();\n");
            output.write("        if ((actions & CREATE) == CREATE) {\n");
            output.write("");
            this.generateSecurity(output, clazz, "securityCreate");
            output.write("\n");
            output.write("        }\n");
            output.write("        if ((actions & LOAD) == LOAD) {\n");
            output.write("");
            this.generateSecurity(output, clazz, "securityLoad");
            output.write("\n");
            output.write("        }\n");
            output.write("        if ((actions & UPDATE) == UPDATE) {\n");
            output.write("");
            this.generateSecurity(output, clazz, "securityUpdate");
            output.write("\n");
            output.write("        }\n");
            output.write("        if ((actions & DELETE) == DELETE) {\n");
            output.write("");
            this.generateSecurity(output, clazz, "securityDelete");
            output.write("\n");
            output.write("        }\n");
            output.write("        return resultPermissions;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Retourne les permissions a verifier pour l'acces a l'entite pour le service Taas\n");
            output.write("     * @param topiaId topiaId d'une entite\n");
            output.write("     * @param actions actions souhait\u00e9es\n");
            output.write("     * @param query requete pour avoir le prochain topiaId\n");
            output.write("     * @param daoClass delegation du getRequestPermission\n");
            output.write("     * @return la liste des permissions\n");
            output.write("     */\n");
            output.write("    protected List<Permission> getRequestPermission(String topiaId, int actions, String query, Class daoClass) throws TopiaException {\n");
            output.write("        TopiaContextImplementor context = getContext();\n");
            output.write("        List<String> result = context.find(query, \"id\", topiaId);\n");
            output.write("\n");
            output.write("        List<Permission> resultPermissions = new ArrayList<Permission>();\n");
            output.write("        for (String topiaIdPermission : result) {\n");
            output.write("            TopiaDAO dao = context.getDAO(daoClass);\n");
            output.write("            List<Permission> permissions = dao.getRequestPermission(topiaIdPermission, actions);\n");
            output.write("            if(permissions != null) {\n");
            output.write("                resultPermissions.addAll(permissions);\n");
            output.write("            } else {\n");
            output.write("                TaasPermission permission = new TaasPermission(topiaIdPermission, actions);\n");
            output.write("                resultPermissions.add(permission);\n");
            output.write("            }\n");
            output.write("        }\n");
            output.write("        return resultPermissions;\n");
            output.write("    }\n");
            output.write("");
        }
        output.write("\n");
        output.write("} // " + clazz.getName() + "DAOAbstract\n");
        output.write("");
    }

    private void generateDAOOperations(Writer output, Collection<ObjectModelOperation> operations) throws IOException {
        for (ObjectModelOperation op : operations) {
            String opName = op.getName();
            output.write("    /**\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                String opDocumentation = op.getDocumentation();
                output.write("     * " + opName + " : " + opDocumentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write(" ");
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            output.write("     */\n");
            output.write("    " + opVisibility + " abstract " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            exceptions.add("TopiaException");
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
        }
    }

    private boolean isCollectionNeeded(Collection<ObjectModelOperation> operations) {
        return this.isImportNeeded(operations, "Collection");
    }

    private boolean isSetNeeded(Collection<ObjectModelOperation> operations) {
        return this.isImportNeeded(operations, "Set");
    }

    private boolean isImportNeeded(Collection<ObjectModelOperation> operations, String importName) {
        for (ObjectModelOperation op : operations) {
            if (op.getReturnType().contains(importName)) {
                return true;
            }
            for (ObjectModelParameter param : op.getParameters()) {
                if (!param.getType().contains(importName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection<ObjectModelOperation> getDAOOperations(ObjectModelClass clazz) {
        ArrayList<ObjectModelOperation> results = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (!op.hasStereotype("dao")) continue;
            results.add(op);
        }
        return results;
    }

    private void generateSecurity(Writer output, ObjectModelClass clazz, String securityTagName) throws IOException {
        if (clazz.hasTagValue(securityTagName)) {
            String[] valuesSecurity;
            String security = clazz.getTagValue(securityTagName);
            Pattern propertiesPattern = Pattern.compile("((?:[_a-zA-Z0-9]+\\.)+(?:_?[A-Z][_a-zA-Z0-9]*\\.)+)attribute\\.(?:([_a-z0-9][_a-zA-Z0-9]*))#(?:(create|load|update|delete))");
            for (String valueSecurity : valuesSecurity = security.split(":")) {
                Matcher matcher = propertiesPattern.matcher(valueSecurity);
                matcher.find();
                String className = matcher.group(1);
                className = StringUtil.substring((String)className, (int)0, (int)-1);
                String attributeName = matcher.group(2);
                String actions = matcher.group(3).toUpperCase();
                String query = "";
                String daoClass = "";
                if (className.equals(clazz.getQualifiedName())) {
                    query = "select " + attributeName + ".topiaId from " + clazz.getQualifiedName() + " where topiaId = :id";
                    daoClass = clazz.getAttribute(attributeName).getClassifier().getQualifiedName();
                } else {
                    query = "select at.topiaId from " + className + " at inner join at." + attributeName + " cl where cl.topiaId = :id";
                    daoClass = className;
                }
                output.write("            resultPermissions.addAll(getRequestPermission(topiaId,\n");
                output.write("                                                            " + actions + ",\n");
                output.write("                                                            \"" + query + "\",\n");
                output.write("                                                            " + daoClass + ".class));\n");
                output.write("");
            }
        } else {
            output.write("            return null;\n");
            output.write("");
        }
    }

    protected void generateNoNMultiplicity(Writer output, ObjectModelAttribute attr, boolean isAssoc) throws IOException {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String propertyName = attrName;
        if (!isAssoc && attr.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attr.getAssociationClass().getName()) + "." + propertyName;
        }
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Retourne le premier \u00e9l\u00e9ment trouv\u00e9 ayant comme valeur pour l'attribut\n");
        output.write("     * " + attrName + " le param\u00e8tre\n");
        output.write("     * @param v la valeur que doit avoir " + attrName + "\n");
        output.write("     * @return un element ou null\n");
        output.write("     */\n");
        output.write("    public E findBy" + TopiaGeneratorUtil.capitalize(attrName) + "(" + attrType + " v) throws TopiaException {\n");
        output.write("        E result = findByProperty(\"" + propertyName + "\", v);\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut\n");
        output.write("     * " + attrName + " le param\u00e8tre\n");
        output.write("     * @param v la valeur que doit avoir " + attrName + "\n");
        output.write("     * @return une liste\n");
        output.write("     */\n");
        output.write("    public List<E> findAllBy" + TopiaGeneratorUtil.capitalize(attrName) + "(" + attrType + " v) throws TopiaException {\n");
        output.write("        List<E> result = findAllByProperty(\"" + propertyName + "\", v);\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("");
        if (attr.hasAssociationClass()) {
            String assocClassName = attr.getAssociationClass().getName();
            String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Retourne le premier \u00e9l\u00e9ment trouv\u00e9 ayant comme valeur pour l'attribut\n");
            output.write("     * " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " le param\u00e8tre\n");
            output.write("     * @param value la valeur que doit avoir " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + "\n");
            output.write("     * @return un element ou null\n");
            output.write("     */\n");
            output.write("    public E findBy" + TopiaGeneratorUtil.capitalize(assocClassName) + "(" + assocClassFQN + " value) throws TopiaException {\n");
            output.write("        E result = findByProperty(\"" + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + "\", value);\n");
            output.write("        return result;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    /**\n");
            output.write("     * Retourne les \u00e9l\u00e9ments ayant comme valeur pour l'attribut\n");
            output.write("     * " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + " le param\u00e8tre\n");
            output.write("     * @param value la valeur que doit avoir " + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + "\n");
            output.write("     * @return une liste\n");
            output.write("     */\n");
            output.write("    public List<E> findAllBy" + TopiaGeneratorUtil.capitalize(assocClassName) + "(" + assocClassFQN + " value) throws TopiaException {\n");
            output.write("        List<E> result = findAllByProperty(\"" + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)assocClassName) + "\", value);\n");
            output.write("        return result;\n");
            output.write("    }\n");
            output.write("");
        }
    }

    protected void generateNMultiplicity(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrName = attr.getName();
        String attrType = attr.getType();
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Retourne le premier \u00e9l\u00e9ment trouv\u00e9 dont l'attribut\n");
        output.write("     * " + attrName + " contient le param\u00e8tre\n");
        output.write("     * @param v la valeur que doit contenir " + attrName + "\n");
        output.write("     * @return un element ou null\n");
        output.write("     */\n");
        output.write("    public E findContains" + TopiaGeneratorUtil.capitalize(attrName) + "(" + attrType + " ... v) throws TopiaException {\n");
        output.write("        E result = findContainsProperties(\"" + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attrName) + "\", Arrays.asList(v));\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("    /**\n");
        output.write("     * Retourne les \u00e9l\u00e9ments trouv\u00e9 dont l'attribut\n");
        output.write("     * " + attrName + " contient le param\u00e8tre\n");
        output.write("     * @param v la valeur que doit contenir " + attrName + "\n");
        output.write("     * @return une liste\n");
        output.write("     */\n");
        output.write("    public List<E> findAllContains" + TopiaGeneratorUtil.capitalize(attrName) + "(" + attrType + " ... v) throws TopiaException {\n");
        output.write("        List<E> results = findAllContainsProperties(\"" + TopiaGeneratorUtil.toLowerCaseFirstLetter((String)attrName) + "\", Arrays.asList(v));\n");
        output.write("        return results;\n");
        output.write("    }\n");
        output.write("");
    }
}

