/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.google.common.base.Objects;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ValidationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nuiton.validator.xwork2.field.NuitonFieldExpressionValidator;

public class CollectionFieldExpressionValidator
extends NuitonFieldExpressionValidator {
    protected Mode mode;
    protected String collectionFieldName;
    protected boolean useSensitiveContext;
    protected String expressionForFirst;
    protected String expressionForLast;
    protected String[] keys;
    protected WalkerContext c;
    private boolean useFirst;
    private boolean useLast;
    protected ValueStack stack;
    Comparator<? super Object> comparator;

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getCollectionFieldName() {
        return this.collectionFieldName;
    }

    public void setCollectionFieldName(String collectionFieldName) {
        this.collectionFieldName = collectionFieldName;
    }

    public boolean isUseSensitiveContext() {
        return this.useSensitiveContext;
    }

    public void setUseSensitiveContext(boolean useSensitiveContext) {
        this.useSensitiveContext = useSensitiveContext;
    }

    public String getExpressionForFirst() {
        return this.expressionForFirst;
    }

    public void setExpressionForFirst(String expressionForFirst) {
        this.expressionForFirst = expressionForFirst;
    }

    public String getExpressionForLast() {
        return this.expressionForLast;
    }

    public void setExpressionForLast(String expressionForLast) {
        this.expressionForLast = expressionForLast;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys != null && keys.length == 1 && keys[0].contains(",") ? keys[0].split(",") : keys;
    }

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        boolean answer;
        if (this.mode == null) {
            throw new ValidationException("no mode defined!");
        }
        this.useFirst = this.expressionForFirst != null && !this.expressionForFirst.trim().isEmpty();
        boolean bl = this.useLast = this.expressionForLast != null && !this.expressionForLast.trim().isEmpty();
        if (this.useFirst && this.mode != Mode.ALL) {
            throw new ValidationException("can  only use expressionForFirst in mode ALL but was " + (Object)((Object)this.mode));
        }
        if (this.useLast && this.mode != Mode.ALL) {
            throw new ValidationException("can  only use expressionForLast in mode ALL but was " + (Object)((Object)this.mode));
        }
        String fieldName = this.getFieldName();
        Collection<?> col = this.getCollection(object);
        if (this.useSensitiveContext) {
            this.c = new WalkerContext(col.size());
        }
        boolean pop = false;
        if (!this.stack.getRoot().contains(object)) {
            this.stack.push(object);
            pop = true;
        }
        switch (this.mode) {
            case ALL: {
                answer = this.validateAllEntries(col);
                break;
            }
            case AT_LEAST_ONE: {
                answer = this.validateAtLeastOneEntry(col);
                break;
            }
            case EXACTLY_ONE: {
                answer = this.validateExtacltyOneEntry(col);
                break;
            }
            case NONE: {
                answer = this.validateNoneEntry(col);
                break;
            }
            case UNIQUE_KEY: {
                if (this.keys == null || this.keys.length == 0) {
                    throw new ValidationException("no unique keys defined");
                }
                answer = this.validateUniqueKey(col);
                break;
            }
            default: {
                answer = false;
            }
        }
        if (!answer) {
            this.addFieldError(fieldName, object);
        }
        if (pop) {
            this.stack.pop();
        }
    }

    public void setValueStack(ValueStack stack) {
        super.setValueStack(stack);
        this.stack = stack;
    }

    public String getMessage(Object object) {
        boolean pop = false;
        if (this.useSensitiveContext && !this.stack.getRoot().contains((Object)this.c)) {
            this.stack.push((Object)this.c);
            pop = true;
        }
        String message = super.getMessage(object);
        if (pop) {
            this.stack.pop();
        }
        return message;
    }

    protected Boolean validateAllEntries(Collection<?> col) throws ValidationException {
        Object entry;
        boolean answer = true;
        Iterator<?> iterator = col.iterator();
        while (iterator.hasNext() && (answer = this.validateOneEntry(entry = iterator.next()))) {
        }
        return answer;
    }

    protected Boolean validateNoneEntry(Collection<?> col) throws ValidationException {
        boolean answer = true;
        for (Object entry : col) {
            boolean b = this.validateOneEntry(entry);
            if (!b) continue;
            answer = false;
            break;
        }
        return answer;
    }

    protected Boolean validateAtLeastOneEntry(Collection<?> col) throws ValidationException {
        Object entry;
        boolean answer = false;
        Iterator<?> iterator = col.iterator();
        while (iterator.hasNext() && !(answer = this.validateOneEntry(entry = iterator.next()))) {
        }
        return answer;
    }

    protected Boolean validateExtacltyOneEntry(Collection<?> col) throws ValidationException {
        Object entry;
        boolean answer;
        int count = 0;
        Iterator<?> iterator = col.iterator();
        while (iterator.hasNext() && (!(answer = this.validateOneEntry(entry = iterator.next())) || ++count <= 1)) {
        }
        return count == 1;
    }

    protected Boolean validateUniqueKey(Collection<?> col) throws ValidationException {
        boolean answer = true;
        Comparator<? super Object> comparator1 = this.getComparator();
        TreeSet<? super Object> hashCodes = new TreeSet<Object>(comparator1);
        int index = -1;
        for (Object entry : col) {
            ++index;
            boolean wasAdded = hashCodes.add(entry);
            if (wasAdded) continue;
            answer = false;
            if (!this.log.isDebugEnabled()) break;
            this.log.debug("duplicated unique entry at position: " + index, new String[0]);
            break;
        }
        return answer;
    }

    protected boolean validateOneEntry(Object object) throws ValidationException {
        Boolean answer = Boolean.FALSE;
        boolean extraExpression = false;
        if (this.useSensitiveContext) {
            this.c.addCurrent(object);
            object = this.c;
            if (this.c.isFirst() && this.useFirst) {
                answer = this.evaluateExpression(this.expressionForFirst, object);
                extraExpression = true;
            }
            if (this.c.isLast() && this.useLast) {
                answer = (!extraExpression || answer != false) && this.evaluateExpression(this.expressionForLast, object);
                extraExpression = true;
            }
        }
        answer = (!extraExpression || answer != false) && this.evaluateExpression(this.getExpression(), object);
        return answer;
    }

    protected boolean evaluateExpression(String expression, Object object) throws ValidationException {
        Object obj = null;
        try {
            obj = this.getFieldValue(expression, object);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e, new String[0]);
        }
        Boolean answer = Boolean.FALSE;
        if (obj != null && obj instanceof Boolean) {
            answer = (Boolean)obj;
        } else {
            this.log.warn("Got result of " + obj + " when trying to get Boolean for expression " + expression, new String[0]);
        }
        return answer;
    }

    protected Collection<?> getCollection(Object object) throws ValidationException {
        String fieldName = this.getCollectionFieldName();
        if (fieldName == null || fieldName.trim().isEmpty()) {
            fieldName = this.getFieldName();
        }
        Object obj = null;
        try {
            obj = this.getFieldValue(fieldName, object);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (obj == null) {
            return Collections.emptyList();
        }
        if (!Collection.class.isInstance(obj)) {
            throw new ValidationException("field " + fieldName + " is not a collection type! (" + obj.getClass() + ")");
        }
        return (Collection)obj;
    }

    protected Integer getUniqueKeyHashCode(Object o) throws ValidationException {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (String key : this.keys) {
            Object property = this.getFieldValue(key, o);
            if (this.log.isDebugEnabled()) {
                this.log.debug("key " + key + " : " + property, new String[0]);
            }
            builder.append(property);
        }
        return builder.toHashCode();
    }

    public String getValidatorType() {
        return "collectionFieldExpression";
    }

    private Comparator<? super Object> getComparator() {
        if (this.comparator == null) {
            this.comparator = new MyComparator<Object>(this.keys);
        }
        return this.comparator;
    }

    protected Object getPropertyValue(String key, Object o) {
        try {
            return this.getFieldValue(key, o);
        }
        catch (ValidationException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Can't get property '" + key + "'value on oject: " + o, new String[0]);
            }
            return null;
        }
    }

    private class MyComparator<O>
    implements Comparator<O> {
        private final String[] keys;

        public MyComparator(String ... keys) {
            this.keys = keys;
        }

        @Override
        public int compare(O o1, O o2) {
            Object property2;
            String key;
            Object property1;
            boolean equals = true;
            String[] stringArray = this.keys;
            int n = stringArray.length;
            for (int i = 0; i < n && (equals = Objects.equal((Object)(property1 = CollectionFieldExpressionValidator.this.getPropertyValue(key = stringArray[i], o1)), (Object)(property2 = CollectionFieldExpressionValidator.this.getPropertyValue(key, o2)))); ++i) {
            }
            return equals ? 0 : -1;
        }
    }

    public class WalkerContext {
        protected final int size;
        protected int index = -1;
        protected Object current;
        protected Object previous;

        public WalkerContext(int size) {
            this.size = size;
        }

        public void addCurrent(Object current) {
            ++this.index;
            this.previous = this.current;
            this.current = current;
        }

        public Object getCurrent() {
            return this.current;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.size - 1;
        }
    }

    public static enum Mode {
        AT_LEAST_ONE,
        EXACTLY_ONE,
        ALL,
        NONE,
        UNIQUE_KEY;

    }
}

