/*
 * #%L
 * Nuiton Utils
 * 
 * $Id: EnumConverter.java 1851 2010-05-11 11:24:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-1.3.1/src/main/java/org/nuiton/util/EnumConverter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.util;

import org.apache.commons.beanutils.ConversionException;
import static org.apache.commons.logging.LogFactory.getLog;
import static org.nuiton.i18n.I18n._;

import java.util.EnumSet;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;

/**
 * classe pour convertir une chaine en un objet Enum type-safe en
 * connaissant le type d'enumération utilisée {@link #enumType}.
 * <p/>
 * Il est possible aussi de convertir une Enum à partir de sa valeur ordinal.
 * <p/>
 * Pour enregister un nouveau convertissemnt pour un type d'Enum utiliser les
 * méthodes {@link ConverterUtil#registerEnumConverter(Class)}, et
 * {@link ConverterUtil#registerEnumConverter(Class,Object)}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see Enum
 * @see Enum#ordinal()
 * @deprecated since 1.3, use now the {@link org.nuiton.util.converter.EnumConverter} class.
 */
@Deprecated
public class EnumConverter implements Converter {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static Log log = getLog(EnumConverter.class);

    /** valeur par default à utiliser, si pas non trouvée et {@link #useDefault} actif. */
    protected Object defaultValue;

    /** flag pour utiliser la valeur par defaut {@link #defaultValue} si non trouvé. */
    protected boolean useDefault;

    /** le type de l'énumération à convertir */
    protected Class<?> enumType;

    @Override
    public Object convert(Class aClass, Object value) {
        if (value == null) {
            if (useDefault) {
                return defaultValue;
            }
            throw new ConversionException(
                    _("nuitonutil.error.convertor.noValue", this));
        }
        if (isEnabled(aClass, enumType)) {
            Object result;
            if (isEnabled(value.getClass(), enumType)) {
                result = value;
                return result;
            }
            if (value instanceof String) {
                try {
                    result = valueOf(aClass, value);
                } catch (IllegalArgumentException e) {
                    // try an ordinal conversion
                    result = convertFromOrdinal(aClass, value);
                }
                return result;
            }
            if (value instanceof Integer) {
                // try a ordinal conversion
                result = convertFromOrdinal(aClass, value);
                return result;
            }
        }
        throw new ConversionException(
                _("nuitonutil.error.no.convertor", aClass.getName(), value));
    }

    public EnumConverter(Class<?> enumType, Object defaultValue) {
        this.enumType = enumType;
        this.defaultValue = defaultValue;
        useDefault = defaultValue != null;
        if (log.isDebugEnabled()) {
            log.debug(toString() + '<' + enumType + '>');
        }
    }

    public EnumConverter(Class<?> enumType) {
        this(enumType, null);
    }

    protected static boolean isEnabled(Class<?> aClass, Class<?> enumType) {
        return aClass != null && aClass.isEnum() && aClass == enumType;
    }

    protected Object convertFromOrdinal(Class<?> aClass, Object value) {
        Object result = null;
        try {
            int ordinal = Integer.valueOf(value + "");
            EnumSet<?> vals = allOf(aClass);
            if (ordinal > -1 && ordinal < vals.size()) {
                for (Enum<?> val : vals) {
                    if (val.ordinal() == ordinal) {
                        result = val;
                        break;
                    }
                }
            }
        } catch (NumberFormatException e1) {
            // quiet conversion
            result = null;
        }
        return result;
    }

    protected Object valueOf(Class<?> aClass, Object value) {
        Object result;
        result = Enum.valueOf((Class<Enum>) aClass, (String) value);
        return result;
    }

    protected EnumSet<?> allOf(Class<?> aClass) {
        EnumSet<?> vals;
        vals = EnumSet.allOf((Class<Enum>) aClass);
        return vals;
    }

    public Class<?> getType() {
        return enumType;
    }


}
