/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.profiling;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.spi.HttpServerProvider;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public abstract class NuitonTrace {
    public static final String PORT_OPTION = "nuitonprofiling_webport";
    public static final String AUTO_SAVE_FILENAME_OPTION = "nuitonprofiling_autosavefile";
    protected static boolean initilized = false;
    private static final List<NuitonTrace> instances = new ArrayList<NuitonTrace>();
    protected Map<Method, Statistic> statistics = new LinkedHashMap<Method, Statistic>();
    protected Map<Method, Caller<Method>> callers = new HashMap<Method, Caller<Method>>();
    protected static final ThreadLocal<Stack<Call>> callStack = new ThreadLocal<Stack<Call>>(){

        @Override
        protected Stack<Call> initialValue() {
            Stack<Call> result = new Stack<Call>();
            return result;
        }
    };

    public NuitonTrace() {
        instances.add(this);
    }

    public Statistic getStatistics(Method method) {
        Statistic result = this.statistics.get(method);
        if (result == null) {
            result = new Statistic(method);
            this.statistics.put(method, result);
        }
        return result;
    }

    public Caller<Method> getCallers(Method method) {
        Caller<Method> result = this.callers.get(method);
        if (result == null) {
            result = new Caller();
            this.callers.put(method, result);
        }
        return result;
    }

    @Pointcut
    abstract void executeMethod();

    @Before(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceBeforeExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        long current = System.nanoTime();
        Call stackItem = new Call(method, 0L, current, current);
        callStack.get().push(stackItem);
    }

    @AfterThrowing(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceAfterThrowingExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
    }

    @After(value="executeMethod() && !within(org.nuiton.profiling.NuitonTrace.*)")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        long current = System.nanoTime();
        Stack<Call> callStack = NuitonTrace.callStack.get();
        if (!callStack.isEmpty()) {
            Call stackItem = callStack.pop();
            long timeSpent = current - stackItem.timeStart;
            long timeSpentNestMethod = current - stackItem.timeStartNestMethod;
            Statistic stat = this.getStatistics(method);
            ++stat.call;
            stat.callNestMethod += stackItem.callNestMethod;
            stat.timeTotal += timeSpent;
            stat.timeTotalNestMethod += timeSpentNestMethod;
            if (stat.timeMin > timeSpent) {
                stat.timeMin = timeSpent;
            }
            if (stat.timeMax < timeSpent) {
                stat.timeMax = timeSpent;
            }
            if (!callStack.isEmpty()) {
                Call parent = callStack.peek();
                ++parent.callNestMethod;
                parent.timeStart += timeSpentNestMethod;
                this.getCallers(method).add(parent.method);
            }
        }
    }

    public static Method[] getKeys(Map<Method, Statistic> statistics) {
        Method[] result = statistics.keySet().toArray(new Method[statistics.size()]);
        return result;
    }

    public static String getStatisticsCSVAndClear() {
        StringBuilder result = new StringBuilder();
        result.append("method;").append("call;").append("min;").append("mean;").append("max;").append("total;").append("call_nest;").append("total_with_nest;").append("callers;").append("\n");
        for (NuitonTrace trace : instances) {
            Method[] keys;
            for (Method method : keys = NuitonTrace.getKeys(trace.statistics)) {
                Statistic stat = trace.getStatistics(method);
                Caller<Method> caller = trace.getCallers(method);
                long meanTime = stat.timeTotal / stat.call;
                result.append(method).append(";").append(stat.call).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeMin / 1000000L), (String)"s'.'S")).append(";").append(DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S")).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeMax / 1000000L), (String)"s'.'S")).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeTotal / 1000000L), (String)"s'.'S")).append(";").append(stat.callNestMethod).append(";").append(DurationFormatUtils.formatDuration((long)(stat.timeTotalNestMethod / 1000000L), (String)"s'.'S")).append(";").append(caller).append("\n");
            }
            trace.statistics.clear();
            trace.callers.clear();
        }
        return result.toString();
    }

    public static String getStatisticsJson() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        String separator = "";
        for (NuitonTrace trace : instances) {
            Method[] keys;
            for (Method method : keys = NuitonTrace.getKeys(trace.statistics)) {
                Statistic stat = trace.getStatistics(method);
                Caller<Method> caller = trace.getCallers(method);
                long meanTime = stat.timeTotal / stat.call;
                result.append(separator);
                separator = ",";
                result.append("'").append(method).append("': {");
                result.append("'method':").append("'").append(method).append("'").append(",").append("'call':").append(stat.call).append(",").append("'min':").append(DurationFormatUtils.formatDuration((long)(stat.timeMin / 1000000L), (String)"s'.'S")).append(",").append("'mean':").append(DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S")).append(",").append("'max':").append(DurationFormatUtils.formatDuration((long)(stat.timeMax / 1000000L), (String)"s'.'S")).append(",").append("'total':").append(DurationFormatUtils.formatDuration((long)(stat.timeTotal / 1000000L), (String)"s'.'S")).append(",").append("'call_nest':").append(stat.callNestMethod).append(",").append("'total_with_nest':").append(DurationFormatUtils.formatDuration((long)(stat.timeTotalNestMethod / 1000000L), (String)"s'.'S")).append(",").append("'callers': [");
                for (Map.Entry<Method, Integer> entry : caller) {
                    result.append("{").append("'caller':").append("'").append(entry.getKey()).append("'").append(",").append("'call':").append(entry.getValue()).append("},");
                }
                result.append("]}").append("\n");
            }
        }
        result.append("}");
        return result.toString();
    }

    public static void clearStatistics() {
        for (NuitonTrace trace : instances) {
            trace.statistics.clear();
            trace.callers.clear();
        }
    }

    public static String getStatisticsAndClear() {
        StringBuilder result = new StringBuilder();
        for (NuitonTrace trace : instances) {
            Method[] keys;
            result.append("--- Statistics ---\n");
            for (Method method : keys = NuitonTrace.getKeys(trace.statistics)) {
                Statistic stat = trace.getStatistics(method);
                long meanTime = stat.timeTotal / stat.call;
                result.append(method).append("\t").append(" call: ").append(stat.call).append(" min: ").append(DurationFormatUtils.formatDuration((long)(stat.timeMin / 1000000L), (String)"s'.'S")).append(" mean: ").append(DurationFormatUtils.formatDuration((long)(meanTime / 1000000L), (String)"s'.'S")).append(" max: ").append(DurationFormatUtils.formatDuration((long)(stat.timeMax / 1000000L), (String)"s'.'S")).append(" total: ").append(DurationFormatUtils.formatDuration((long)(stat.timeTotal / 1000000L), (String)"s'.'S")).append(" call_nest: ").append(stat.callNestMethod).append(" total_with_nest: ").append(DurationFormatUtils.formatDuration((long)(stat.timeTotalNestMethod / 1000000L), (String)"s'.'S")).append(" callers: ").append(trace.getCallers(method)).append("\n");
            }
            result.append("--------------------\n");
            trace.statistics.clear();
            trace.callers.clear();
        }
        return result.toString();
    }

    public static void printStatisticsAndClear() {
        NuitonTrace.printStatisticsAndClear(System.out);
    }

    public static void printStatisticsAndClear(PrintStream printer) {
        String stat = NuitonTrace.getStatisticsAndClear();
        if (stat != null && !"".equals(stat)) {
            printer.println(stat);
        }
    }

    protected static void startWebService(int port) {
        try {
            HttpServerProvider provider = HttpServerProvider.provider();
            InetSocketAddress inet = new InetSocketAddress(port);
            HttpServer server = provider.createHttpServer(inet, 0);
            server.createContext("/", new WebHandler());
            server.createContext("/data", new DataHandler());
            server.createContext("/api", new ApiHandler());
            server.start();
            System.out.println("Nuiton profiling Server is listening on " + inet);
        }
        catch (Throwable eee) {
            System.err.println("Can't start web service on port " + port);
            eee.printStackTrace(System.err);
        }
    }

    protected static String getOption(String optionName) {
        String result = System.getProperty(optionName);
        if (result == null) {
            result = System.getenv(optionName);
        }
        return result;
    }

    protected static void init() {
        if (initilized) {
            return;
        }
        initilized = true;
        System.out.println("Init Nuiton Profiling ...");
        String portString = NuitonTrace.getOption(PORT_OPTION);
        System.out.println("NuitonProfiling web port: " + portString);
        if (portString != null) {
            try {
                int port = Integer.parseInt(portString);
                if (port > 0) {
                    NuitonTrace.startWebService(port);
                }
            }
            catch (Exception eee) {
                eee.printStackTrace(System.err);
                System.err.println("Can't parse port number: " + portString);
            }
        }
        final String file = NuitonTrace.getOption(AUTO_SAVE_FILENAME_OPTION);
        System.out.println("NuitonProfiling auto save file: " + file);
        if (file != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileWriter out = null;
                    try {
                        String stat = NuitonTrace.getStatisticsCSVAndClear();
                        out = new FileWriter(file);
                        out.write(stat);
                    }
                    catch (IOException eee) {
                        try {
                            eee.printStackTrace(System.err);
                            System.err.println("Can't write Statistic file: " + file);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Writer)out);
                    }
                    IOUtils.closeQuietly((Writer)out);
                }
            });
        }
    }

    public static void main(String ... args) {
        System.out.println("Starting Nuiton Profiling ...");
        String portString = args != null && args.length > 0 ? args[0] : NuitonTrace.getOption(PORT_OPTION);
        if (portString == null) {
            portString = "4488";
        }
        System.out.println("NuitonProfiling web port: " + portString);
        if (portString != null) {
            try {
                int port = Integer.parseInt(portString);
                if (port > 0) {
                    NuitonTrace.startWebService(port);
                }
            }
            catch (Exception eee) {
                eee.printStackTrace(System.err);
                System.err.println("Can't parse port number: " + portString);
            }
        }
    }

    static {
        NuitonTrace.init();
    }

    static class ApiHandler
    implements HttpHandler {
        ApiHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                String path = exchange.getRequestURI().getPath();
                if (StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)"clear")) {
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", "text/plain");
                    exchange.sendResponseHeaders(200, 0L);
                    NuitonTrace.clearStatistics();
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write("ok".getBytes());
                    responseBody.close();
                } else {
                    exchange.sendResponseHeaders(404, 0L);
                    exchange.close();
                }
            }
        }
    }

    static class DataHandler
    implements HttpHandler {
        DataHandler() {
        }

        protected String getCallback(HttpExchange exchange) {
            String result = null;
            URI uri = exchange.getRequestURI();
            String query = uri.getQuery();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("[&]")) {
                    String[] param = pair.split("[=]", 2);
                    if (param.length != 2 || !"callback".equalsIgnoreCase(param[0])) continue;
                    result = param[1];
                    break;
                }
            }
            return result;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                Headers responseHeaders = exchange.getResponseHeaders();
                responseHeaders.set("Content-Type", "text/javascript");
                exchange.sendResponseHeaders(200, 0L);
                String jsoncallback = this.getCallback(exchange);
                String json = NuitonTrace.getStatisticsJson();
                if (jsoncallback != null) {
                    json = jsoncallback + "(" + json + ")";
                }
                OutputStream responseBody = exchange.getResponseBody();
                responseBody.write(json.getBytes());
                responseBody.close();
            }
        }
    }

    static class WebHandler
    implements HttpHandler {
        public static final String filepath = "/org/nuiton/profiling/web/";

        WebHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String requestMethod = exchange.getRequestMethod();
            if (requestMethod.equalsIgnoreCase("GET")) {
                String path = exchange.getRequestURI().getPath();
                String file = StringUtils.substringAfterLast((String)path, (String)"/");
                file = (String)StringUtils.defaultIfBlank((CharSequence)file, (CharSequence)"index.html");
                URL resource = this.getClass().getResource(filepath + file);
                if (resource == null) {
                    exchange.sendResponseHeaders(404, 0L);
                    exchange.close();
                } else {
                    String ext = StringUtils.substringAfterLast((String)file, (String)".");
                    String type = StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"mf") ? "text/cache-manifest" : (StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"ico") ? "image/x-icon" : (StringUtils.equalsIgnoreCase((CharSequence)ext, (CharSequence)"js") ? "text/javascript" : "text/" + ext));
                    Headers responseHeaders = exchange.getResponseHeaders();
                    responseHeaders.set("Content-Type", type);
                    exchange.sendResponseHeaders(200, 0L);
                    InputStream in = resource.openStream();
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)content);
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write(content.toByteArray());
                    responseBody.close();
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)content);
                }
            }
        }
    }

    protected static class Caller<E>
    implements Iterable<Map.Entry<E, Integer>> {
        protected Map<E, Integer> data = new HashMap<E, Integer>();

        protected Caller() {
        }

        public void add(E e) {
            Integer v = this.data.get(e);
            if (v == null) {
                v = 0;
            }
            this.data.put(e, v + 1);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (Map.Entry<E, Integer> e : this) {
                result.append(e.getValue()).append("=[").append(e.getKey()).append("]").append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }

        @Override
        public Iterator<Map.Entry<E, Integer>> iterator() {
            Comparator comparator = new Comparator<Map.Entry<E, Integer>>(){

                @Override
                public int compare(Map.Entry<E, Integer> o1, Map.Entry<E, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            };
            Set<Map.Entry<E, Integer>> entries = this.data.entrySet();
            TreeSet<Map.Entry<E, Integer>> sorted = new TreeSet<Map.Entry<E, Integer>>(comparator);
            sorted.addAll(entries);
            return sorted.iterator();
        }
    }

    protected static class Call {
        Method method;
        long callNestMethod;
        long timeStart;
        long timeStartNestMethod;

        public Call(Method method, long callNestMethod, long timeStart, long timeStartNestMethod) {
            this.method = method;
            this.callNestMethod = callNestMethod;
            this.timeStart = timeStart;
            this.timeStartNestMethod = timeStartNestMethod;
        }
    }

    protected static class Statistic {
        Method method;
        long call;
        long callNestMethod;
        long timeMin;
        long timeMax;
        long timeTotal;
        long timeTotalNestMethod;

        public Statistic(Method method) {
            this.method = method;
        }
    }
}

