/* *##% NuitonMatrix
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.math.matrix;

import java.util.Arrays;

/**
 * FloatBigVector.
 *
 * Created: 6 octobre 2005 02:54:36 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 164 $
 *
 * Last update: $Date: 2009-06-16 20:13:11 +0200 (mar., 16 juin 2009) $
 * by : $Author: tchemit $
 */
public class FloatBigVector implements Vector { // FloatBigVector

    protected float data[] = null;

    public FloatBigVector(int capacity) {
        data = new float[capacity];
    }

    public int size() {
        return data.length;
    }

    public double getMaxOccurence() {
        return MatrixHelper.maxOccurence(data);
    }

    public double getValue(int pos) {
        return data[pos];
    }

    public void setValue(int pos, double value) {
        data[pos] = (float) value;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof FloatBigVector) {
            FloatBigVector other = (FloatBigVector) o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector) o;
            result = true;
            for (int i = 0; i < size() && result; i++) {
                result = getValue(i) == other.getValue(i);
            }
        }
        return result;
    }

    public boolean isImplementedPaste(Vector v) {
        return v instanceof FloatBigVector;
    }

    public boolean isImplementedAdd(Vector v) {
        return v instanceof FloatBigVector;
    }

    public boolean isImplementedMinus(Vector v) {
        return v instanceof FloatBigVector;
    }

    public boolean isImplementedMap() {
        return true;
    }

    public void paste(Vector v) {
        FloatBigVector fbv = (FloatBigVector) v;
        System.arraycopy(fbv.data, 0, this.data, 0, this.size());
    }

    public void add(Vector v) {
        FloatBigVector fbv = (FloatBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] += fbv.data[i];
        }
    }

    public void minus(Vector v) {
        FloatBigVector fbv = (FloatBigVector) v;
        for (int i = 0; i < data.length; i++) {
            data[i] -= fbv.data[i];
        }
    }

    public void map(MapFunction f) {
        for (int i = 0; i < data.length; i++) {
            data[i] = (float) f.apply(data[i]);
        }
    }

} // FloatBigVector

