/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin.io;

import com.google.common.io.Files;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.config.plugin.io.ConfigModelIO;
import org.nuiton.config.plugin.io.ReadConfigModelException;
import org.nuiton.config.plugin.io.WriteConfigModelException;
import org.nuiton.config.plugin.model.ConfigModel;
import org.nuiton.config.plugin.model.OptionModel;

@Component(role=ConfigModelIO.class, hint="toml")
public class ConfigModelIOTomlImpl
implements ConfigModelIO {
    @Override
    public ConfigModel read(Path path) throws ReadConfigModelException {
        ConfigModel configModel;
        block9: {
            BufferedReader reader = Files.newReader((File)path.toFile(), (Charset)StandardCharsets.UTF_8);
            try {
                Toml toml = new Toml().read((Reader)reader);
                ConfigModel configModel2 = (ConfigModel)toml.to(ConfigModel.class);
                for (OptionModel optionModel : configModel2.getOptions()) {
                    optionModel.setType(optionModel.getType());
                }
                configModel = configModel2;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ReadConfigModelException("Can't real toml config model from file: " + path, e);
                }
            }
            ((Reader)reader).close();
        }
        return configModel;
    }

    @Override
    public void write(ConfigModel configModel, Path path) throws WriteConfigModelException {
        try (BufferedWriter writer = Files.newWriter((File)path.toFile(), (Charset)StandardCharsets.UTF_8);){
            new TomlWriter().write((Object)configModel, (Writer)writer);
        }
        catch (Exception e) {
            throw new WriteConfigModelException("Can't write toml config model from file: " + path, e);
        }
    }
}

